@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property releaseNote (Available since v1.216.0) The revised version Code of the database engine is used to specify the upgrade to the target version.
 * @property releaseType (Available since v1.216.0) Database version release status. Valid values are `Stable`, `Old`, `HighRisk`.
 * @property revisionVersionCode (Available since v1.216.0) The revised version Code of the database engine is used to specify the upgrade to the target version.
 * @property revisionVersionName (Available since v1.216.0) The revision version number of the database engine.
 */
public data class ClusterDbRevisionVersionList(
    public val releaseNote: String? = null,
    public val releaseType: String? = null,
    public val revisionVersionCode: String? = null,
    public val revisionVersionName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.ClusterDbRevisionVersionList): ClusterDbRevisionVersionList = ClusterDbRevisionVersionList(
            releaseNote = javaType.releaseNote().map({ args0 -> args0 }).orElse(null),
            releaseType = javaType.releaseType().map({ args0 -> args0 }).orElse(null),
            revisionVersionCode = javaType.revisionVersionCode().map({ args0 -> args0 }).orElse(null),
            revisionVersionName = javaType.revisionVersionName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
