@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountDescription Account description.
 * @property accountLockState Account lock state, Valid values are `Lock`, `UnLock`.
 * @property accountName Account name.
 * @property accountStatus Cluster address type.`Cluster`: the default address of the Cluster.`Primary`: Primary address.`Custom`: Custom cluster addresses.
 * @property accountType Account type, Valid values are `Normal`, `Super`.
 * @property databasePrivileges A list of database privilege. Each element contains the following attributes.
 */
public data class GetAccountsAccount(
    public val accountDescription: String,
    public val accountLockState: String,
    public val accountName: String,
    public val accountStatus: String,
    public val accountType: String,
    public val databasePrivileges: List<GetAccountsAccountDatabasePrivilege>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetAccountsAccount): GetAccountsAccount = GetAccountsAccount(
            accountDescription = javaType.accountDescription(),
            accountLockState = javaType.accountLockState(),
            accountName = javaType.accountName(),
            accountStatus = javaType.accountStatus(),
            accountType = javaType.accountType(),
            databasePrivileges = javaType.databasePrivileges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.polardb.kotlin.outputs.GetAccountsAccountDatabasePrivilege.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
