@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property chargeType Billing method. Value options: `PostPaid` for Pay-As-You-Go and `PrePaid` for subscription.
 * @property connectionString PolarDB cluster connection string.
 * @property createTime The create_time of the db_nodes.
 * @property dbNodeClass The db_node_class of the db_nodes.
 * @property dbNodeNumber The DBNodeNumber of the PolarDB cluster.
 * @property dbNodes The DBNodes of the PolarDB cluster.
 * @property dbType Database type. Options are `MySQL`, `Oracle` and `PostgreSQL`. If no value is specified, all types are returned.
 * @property dbVersion The DBVersion of the PolarDB cluster.
 * @property deleteLock The DeleteLock of the PolarDB cluster.
 * @property description The description of the PolarDB cluster.
 * @property engine Database type. Options are `MySQL`, `Oracle` and `PostgreSQL`. If no value is specified, all types are returned.
 * @property expireTime Expiration time. Pay-As-You-Go clusters never expire.
 * @property expired The expired of the PolarDB cluster.
 * @property id The ID of the PolarDB cluster.
 * @property lockMode The LockMode of the PolarDB cluster.
 * @property networkType The DBClusterNetworkType of the PolarDB cluster.
 * @property port PolarDB cluster connection port.
 * @property regionId The region_id of the db_nodes.
 * @property status status of the cluster.
 * @property storageUsed The StorageUsed of the PolarDB cluster.
 * @property vpcId ID of the VPC the cluster belongs to.
 * @property zoneId The zone_id of the db_nodes.
 */
public data class GetClustersCluster(
    public val chargeType: String,
    public val connectionString: String,
    public val createTime: String,
    public val dbNodeClass: String,
    public val dbNodeNumber: Int,
    public val dbNodes: List<GetClustersClusterDbNode>,
    public val dbType: String,
    public val dbVersion: String,
    public val deleteLock: Int,
    public val description: String,
    public val engine: String,
    public val expireTime: String,
    public val expired: String,
    public val id: String,
    public val lockMode: String,
    public val networkType: String,
    public val port: String,
    public val regionId: String,
    public val status: String,
    public val storageUsed: Int,
    public val vpcId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetClustersCluster): GetClustersCluster = GetClustersCluster(
            chargeType = javaType.chargeType(),
            connectionString = javaType.connectionString(),
            createTime = javaType.createTime(),
            dbNodeClass = javaType.dbNodeClass(),
            dbNodeNumber = javaType.dbNodeNumber(),
            dbNodes = javaType.dbNodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.polardb.kotlin.outputs.GetClustersClusterDbNode.Companion.toKotlin(args0)
                })
            }),
            dbType = javaType.dbType(),
            dbVersion = javaType.dbVersion(),
            deleteLock = javaType.deleteLock(),
            description = javaType.description(),
            engine = javaType.engine(),
            expireTime = javaType.expireTime(),
            expired = javaType.expired(),
            id = javaType.id(),
            lockMode = javaType.lockMode(),
            networkType = javaType.networkType(),
            port = javaType.port(),
            regionId = javaType.regionId(),
            status = javaType.status(),
            storageUsed = javaType.storageUsed(),
            vpcId = javaType.vpcId(),
            zoneId = javaType.zoneId(),
        )
    }
}
