@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The create_time of the db_nodes.
 * @property dbNodeClass The db_node_class of the db_nodes.
 * @property dbNodeId The db_node_id of the db_nodes.
 * @property dbNodeRole The db_node_role of the db_nodes.
 * @property dbNodeStatus The db_node_status of the db_nodes.
 * @property maxConnections The max_connections of the db_nodes.
 * @property maxIops The max_iops of the db_nodes.
 * @property regionId The region_id of the db_nodes.
 * @property zoneId The zone_id of the db_nodes.
 */
public data class GetClustersClusterDbNode(
    public val createTime: String,
    public val dbNodeClass: String,
    public val dbNodeId: String,
    public val dbNodeRole: String,
    public val dbNodeStatus: String,
    public val maxConnections: Int,
    public val maxIops: Int,
    public val regionId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetClustersClusterDbNode): GetClustersClusterDbNode = GetClustersClusterDbNode(
            createTime = javaType.createTime(),
            dbNodeClass = javaType.dbNodeClass(),
            dbNodeId = javaType.dbNodeId(),
            dbNodeRole = javaType.dbNodeRole(),
            dbNodeStatus = javaType.dbNodeStatus(),
            maxConnections = javaType.maxConnections(),
            maxIops = javaType.maxIops(),
            regionId = javaType.regionId(),
            zoneId = javaType.zoneId(),
        )
    }
}
