@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getClusters.
 * @property clusters A list of PolarDB clusters. Each element contains the following attributes:
 * @property dbType `Primary` for primary cluster, `ReadOnly` for read-only cluster, `Guard` for disaster recovery cluster, and `Temp` for temporary cluster.
 * @property descriptionRegex
 * @property descriptions A list of RDS cluster descriptions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of RDS cluster IDs.
 * @property outputFile
 * @property status Status of the cluster.
 * @property tags
 */
public data class GetClustersResult(
    public val clusters: List<GetClustersCluster>,
    public val dbType: String? = null,
    public val descriptionRegex: String? = null,
    public val descriptions: List<String>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetClustersResult): GetClustersResult = GetClustersResult(
            clusters = javaType.clusters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.polardb.kotlin.outputs.GetClustersCluster.Companion.toKotlin(args0)
                })
            }),
            dbType = javaType.dbType().map({ args0 -> args0 }).orElse(null),
            descriptionRegex = javaType.descriptionRegex().map({ args0 -> args0 }).orElse(null),
            descriptions = javaType.descriptions().map({ args0 -> args0 }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
