@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accounts A list of accounts of database. Each element contains the following attributes.
 * @property characterSetName The character set name of database.
 * @property dbDescription Database description.
 * @property dbName Database name.
 * @property dbStatus The status of database.
 * @property engine The engine of database.
 */
public data class GetDatabasesDatabase(
    public val accounts: List<GetDatabasesDatabaseAccount>,
    public val characterSetName: String,
    public val dbDescription: String,
    public val dbName: String,
    public val dbStatus: String,
    public val engine: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetDatabasesDatabase): GetDatabasesDatabase = GetDatabasesDatabase(
            accounts = javaType.accounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.polardb.kotlin.outputs.GetDatabasesDatabaseAccount.Companion.toKotlin(args0)
                })
            }),
            characterSetName = javaType.characterSetName(),
            dbDescription = javaType.dbDescription(),
            dbName = javaType.dbName(),
            dbStatus = javaType.dbStatus(),
            engine = javaType.engine(),
        )
    }
}
