@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDatabases.
 * @property databases A list of PolarDB cluster databases. Each element contains the following attributes:
 * @property dbClusterId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property nameRegex
 * @property names database name of the cluster.
 */
public data class GetDatabasesResult(
    public val databases: List<GetDatabasesDatabase>,
    public val dbClusterId: String,
    public val id: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetDatabasesResult): GetDatabasesResult = GetDatabasesResult(
            databases = javaType.databases().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.polardb.kotlin.outputs.GetDatabasesDatabase.Companion.toKotlin(args0)
                })
            }),
            dbClusterId = javaType.dbClusterId(),
            id = javaType.id(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
        )
    }
}
