@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property addressItems A list of endpoint addresses. Each element contains the following attributes.
 * @property autoAddNewNodes Whether the new node is automatically added to the default cluster address.Options are `Enable` and `Disable`.
 * @property dbEndpointId endpoint of the cluster.
 * @property endpointConfig The Endpoint configuration. `ConsistLevel`: session consistency level, value:`0`: final consistency,`1`: session consistency;`LoadBalanceStrategy`: load balancing strategy. Based on the automatic scheduling of load, the value is: `load`.
 * @property endpointType Cluster address type.`Cluster`: the default address of the Cluster.`Primary`: Primary address.`Custom`: Custom cluster addresses.
 * @property nodes A list of nodes that connect to the address configuration.
 * @property readWriteMode Read-write mode:`ReadWrite`: readable and writable (automatic read-write separation).`ReadOnly`: ReadOnly.
 */
public data class GetEndpointsEndpoint(
    public val addressItems: List<GetEndpointsEndpointAddressItem>,
    public val autoAddNewNodes: String,
    public val dbEndpointId: String,
    public val endpointConfig: String,
    public val endpointType: String,
    public val nodes: String,
    public val readWriteMode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetEndpointsEndpoint): GetEndpointsEndpoint = GetEndpointsEndpoint(
            addressItems = javaType.addressItems().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.polardb.kotlin.outputs.GetEndpointsEndpointAddressItem.Companion.toKotlin(args0)
                })
            }),
            autoAddNewNodes = javaType.autoAddNewNodes(),
            dbEndpointId = javaType.dbEndpointId(),
            endpointConfig = javaType.endpointConfig(),
            endpointType = javaType.endpointType(),
            nodes = javaType.nodes(),
            readWriteMode = javaType.readWriteMode(),
        )
    }
}
