@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property connectionString Connection instance string.
 * @property ipAddress The ip address of connection string.
 * @property netType IP network type:`Public` or `Private`.
 * @property port Intranet connection port.
 * @property vpcId ID of the VPC the instance belongs to.
 * @property vswitchId ID of the vSwitch the cluster belongs to.
 */
public data class GetEndpointsEndpointAddressItem(
    public val connectionString: String,
    public val ipAddress: String,
    public val netType: String,
    public val port: String,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetEndpointsEndpointAddressItem): GetEndpointsEndpointAddressItem = GetEndpointsEndpointAddressItem(
            connectionString = javaType.connectionString(),
            ipAddress = javaType.ipAddress(),
            netType = javaType.netType(),
            port = javaType.port(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
