@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEndpoints.
 * @property dbClusterId
 * @property dbEndpointId The endpoint ID.
 * @property endpoints A list of PolarDB cluster endpoints. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetEndpointsResult(
    public val dbClusterId: String,
    public val dbEndpointId: String? = null,
    public val endpoints: List<GetEndpointsEndpoint>,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetEndpointsResult): GetEndpointsResult = GetEndpointsResult(
            dbClusterId = javaType.dbClusterId(),
            dbEndpointId = javaType.dbEndpointId().map({ args0 -> args0 }).orElse(null),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.polardb.kotlin.outputs.GetEndpointsEndpoint.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
        )
    }
}
