@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime The time when the Global Database Network was created. The time is in the YYYY-MM-DDThh:mm:ssZ format. The time is displayed in UTC.
 * @property dbClusters The details of each cluster in the Global Database Network.
 * @property dbType The type of the database engine. Only MySQL is supported.
 * @property dbVersion The version number of the database engine. Only the 8.0 version is supported.
 * @property description The description of the Global Database Network.
 * @property gdnId The ID of the Global Database Network.
 * @property id The ID of the Global Database Network.
 * @property status The status of the Global Database Network. Valid values:
 */
public data class GetGlobalDatabaseNetworksNetwork(
    public val createTime: String,
    public val dbClusters: List<GetGlobalDatabaseNetworksNetworkDbCluster>,
    public val dbType: String,
    public val dbVersion: String,
    public val description: String,
    public val gdnId: String,
    public val id: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetGlobalDatabaseNetworksNetwork): GetGlobalDatabaseNetworksNetwork = GetGlobalDatabaseNetworksNetwork(
            createTime = javaType.createTime(),
            dbClusters = javaType.dbClusters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.polardb.kotlin.outputs.GetGlobalDatabaseNetworksNetworkDbCluster.Companion.toKotlin(args0)
                })
            }),
            dbType = javaType.dbType(),
            dbVersion = javaType.dbVersion(),
            description = javaType.description(),
            gdnId = javaType.gdnId(),
            id = javaType.id(),
            status = javaType.status(),
        )
    }
}
