@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGlobalDatabaseNetworks.
 * @property dbClusterId The ID of the PolarDB cluster.
 * @property description The description of the Global Database Network.
 * @property gdnId The ID of the Global Database Network.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property networks A list of PolarDB Global Database Networks. Each element contains the following attributes:
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property status The status of the Global Database Network.
 */
public data class GetGlobalDatabaseNetworksResult(
    public val dbClusterId: String? = null,
    public val description: String? = null,
    public val gdnId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val networks: List<GetGlobalDatabaseNetworksNetwork>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetGlobalDatabaseNetworksResult): GetGlobalDatabaseNetworksResult = GetGlobalDatabaseNetworksResult(
            dbClusterId = javaType.dbClusterId().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            gdnId = javaType.gdnId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            networks = javaType.networks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.polardb.kotlin.outputs.GetGlobalDatabaseNetworksNetwork.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
