@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property supportedEngines A list of PolarDB node classes in the zone.
 * @property zoneId The Zone to launch the PolarDB cluster.
 */
public data class GetNodeClassesClass(
    public val supportedEngines: List<GetNodeClassesClassSupportedEngine>,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetNodeClassesClass): GetNodeClassesClass = GetNodeClassesClass(
            supportedEngines = javaType.supportedEngines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.polardb.kotlin.outputs.GetNodeClassesClassSupportedEngine.Companion.toKotlin(args0)
                })
            }),
            zoneId = javaType.zoneId(),
        )
    }
}
