@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availableResources A list of PolarDB node available classes.
 * @property engine In the zone, the database type supports classes in the following available_resources.
 */
public data class GetNodeClassesClassSupportedEngine(
    public val availableResources: List<GetNodeClassesClassSupportedEngineAvailableResource>,
    public val engine: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetNodeClassesClassSupportedEngine): GetNodeClassesClassSupportedEngine = GetNodeClassesClassSupportedEngine(
            availableResources = javaType.availableResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.polardb.kotlin.outputs.GetNodeClassesClassSupportedEngineAvailableResource.Companion.toKotlin(args0)
                })
            }),
            engine = javaType.engine(),
        )
    }
}
