@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getNodeClasses.
 * @property category
 * @property classes A list of PolarDB node classes. Each element contains the following attributes:
 * @property dbNodeClass PolarDB node available class.
 * @property dbType
 * @property dbVersion
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property payType
 * @property regionId
 * @property zoneId The Zone to launch the PolarDB cluster.
 */
public data class GetNodeClassesResult(
    public val category: String? = null,
    public val classes: List<GetNodeClassesClass>,
    public val dbNodeClass: String? = null,
    public val dbType: String? = null,
    public val dbVersion: String? = null,
    public val id: String,
    public val outputFile: String? = null,
    public val payType: String,
    public val regionId: String? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetNodeClassesResult): GetNodeClassesResult = GetNodeClassesResult(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            classes = javaType.classes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.polardb.kotlin.outputs.GetNodeClassesClass.Companion.toKotlin(args0)
                })
            }),
            dbNodeClass = javaType.dbNodeClass().map({ args0 -> args0 }).orElse(null),
            dbType = javaType.dbType().map({ args0 -> args0 }).orElse(null),
            dbVersion = javaType.dbVersion().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            payType = javaType.payType(),
            regionId = javaType.regionId().map({ args0 -> args0 }).orElse(null),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
