@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The time when the parameter template was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
 * @property dbType The type of the database engine. Only `MySQL` is supported.
 * @property dbVersion The version number of the database engine. Valid values: `5.6`, `5.7`, `8.0`.
 * @property forceRestart Indicates whether to restart the cluster when this parameter template is applied.
 * @property id The ID of the Parameter Group.
 * @property parameterCounts The number of parameters in the parameter template.
 * @property parameterGroupDesc The description of the parameter template.
 * @property parameterGroupId The ID of the Parameter Group.
 * @property parameterGroupName The name of the parameter template.
 * @property parameterGroupType The type of the parameter template.
 */
public data class GetParameterGroupsGroup(
    public val createTime: String,
    public val dbType: String,
    public val dbVersion: String,
    public val forceRestart: String,
    public val id: String,
    public val parameterCounts: Int,
    public val parameterGroupDesc: String,
    public val parameterGroupId: String,
    public val parameterGroupName: String,
    public val parameterGroupType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetParameterGroupsGroup): GetParameterGroupsGroup = GetParameterGroupsGroup(
            createTime = javaType.createTime(),
            dbType = javaType.dbType(),
            dbVersion = javaType.dbVersion(),
            forceRestart = javaType.forceRestart(),
            id = javaType.id(),
            parameterCounts = javaType.parameterCounts(),
            parameterGroupDesc = javaType.parameterGroupDesc(),
            parameterGroupId = javaType.parameterGroupId(),
            parameterGroupName = javaType.parameterGroupName(),
            parameterGroupType = javaType.parameterGroupType(),
        )
    }
}
