@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getParameterGroups.
 * @property dbType The type of the database engine.
 * @property dbVersion The version number of the database engine.
 * @property groups A list of PolarDB Parameter Groups. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names A list of Parameter Group names.
 * @property outputFile
 */
public data class GetParameterGroupsResult(
    public val dbType: String? = null,
    public val dbVersion: String? = null,
    public val groups: List<GetParameterGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.GetParameterGroupsResult): GetParameterGroupsResult = GetParameterGroupsResult(
            dbType = javaType.dbType().map({ args0 -> args0 }).orElse(null),
            dbVersion = javaType.dbVersion().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.polardb.kotlin.outputs.GetParameterGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
