@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.polardb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property paramName The name of a parameter in the parameter template.
 * @property paramValue The value of a parameter in the parameter template.
 */
public data class ParameterGroupParameter(
    public val paramName: String,
    public val paramValue: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.polardb.outputs.ParameterGroupParameter): ParameterGroupParameter = ParameterGroupParameter(
            paramName = javaType.paramName(),
            paramValue = javaType.paramValue(),
        )
    }
}
