@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin

import com.pulumi.alicloud.privatelink.PrivatelinkFunctions.getServicePlain
import com.pulumi.alicloud.privatelink.PrivatelinkFunctions.getVpcEndpointConnectionsPlain
import com.pulumi.alicloud.privatelink.PrivatelinkFunctions.getVpcEndpointServiceResourcesPlain
import com.pulumi.alicloud.privatelink.PrivatelinkFunctions.getVpcEndpointServiceUsersPlain
import com.pulumi.alicloud.privatelink.PrivatelinkFunctions.getVpcEndpointServicesPlain
import com.pulumi.alicloud.privatelink.PrivatelinkFunctions.getVpcEndpointZonesPlain
import com.pulumi.alicloud.privatelink.PrivatelinkFunctions.getVpcEndpointsPlain
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetVpcEndpointConnectionsPlainArgs
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetVpcEndpointConnectionsPlainArgsBuilder
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetVpcEndpointServiceResourcesPlainArgs
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetVpcEndpointServiceResourcesPlainArgsBuilder
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetVpcEndpointServiceUsersPlainArgs
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetVpcEndpointServiceUsersPlainArgsBuilder
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetVpcEndpointServicesPlainArgs
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetVpcEndpointServicesPlainArgsBuilder
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetVpcEndpointZonesPlainArgs
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetVpcEndpointZonesPlainArgsBuilder
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetVpcEndpointsPlainArgs
import com.pulumi.alicloud.privatelink.kotlin.inputs.GetVpcEndpointsPlainArgsBuilder
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointConnectionsResult
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointServiceResourcesResult
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointServiceUsersResult
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointServicesResult
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointZonesResult
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointConnectionsResult.Companion.toKotlin as getVpcEndpointConnectionsResultToKotlin
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointServiceResourcesResult.Companion.toKotlin as getVpcEndpointServiceResourcesResultToKotlin
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointServiceUsersResult.Companion.toKotlin as getVpcEndpointServiceUsersResultToKotlin
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointServicesResult.Companion.toKotlin as getVpcEndpointServicesResultToKotlin
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointZonesResult.Companion.toKotlin as getVpcEndpointZonesResultToKotlin
import com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointsResult.Companion.toKotlin as getVpcEndpointsResultToKotlin

public object PrivatelinkFunctions {
    /**
     * Using this data source can open Privatelink service automatically. If the service has been opened, it will return opened.
     * For information about Privatelink and how to use it, see [What is Privatelink](https://www.alibabacloud.com/help/en/product/120462.htm).
     * > **NOTE:** Available in v1.113.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.privatelink.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.privatelink.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.PrivateLink.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/privatelink"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := privatelink.GetService(ctx, &privatelink.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.privatelink.PrivatelinkFunctions;
     * import com.pulumi.alicloud.privatelink.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = PrivatelinkFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:privatelink:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the Privatelink service that means you have read and agreed the [Privatelink Terms of Service](https://help.aliyun.com/document_detail/197619.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;privatelink&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Privatelink Vpc Endpoint Connections of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.110.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.privatelink.getVpcEndpointConnections({
     *     serviceId: "example_value",
     *     status: "Connected",
     * });
     * export const firstPrivatelinkVpcEndpointConnectionId = example.then(example => example.connections?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.privatelink.get_vpc_endpoint_connections(service_id="example_value",
     *     status="Connected")
     * pulumi.export("firstPrivatelinkVpcEndpointConnectionId", example.connections[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.PrivateLink.GetVpcEndpointConnections.Invoke(new()
     *     {
     *         ServiceId = "example_value",
     *         Status = "Connected",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstPrivatelinkVpcEndpointConnectionId"] = example&#46;Apply(getVpcEndpointConnectionsResult => getVpcEndpointConnectionsResult&#46;Connections[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/privatelink"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := privatelink.GetVpcEndpointConnections(ctx, &privatelink.GetVpcEndpointConnectionsArgs{
     * 			ServiceId: "example_value",
     * 			Status:    pulumi.StringRef("Connected"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstPrivatelinkVpcEndpointConnectionId", example.Connections[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.privatelink.PrivatelinkFunctions;
     * import com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointConnectionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = PrivatelinkFunctions.getVpcEndpointConnections(GetVpcEndpointConnectionsArgs.builder()
     *             .serviceId("example_value")
     *             .status("Connected")
     *             .build());
     *         ctx.export("firstPrivatelinkVpcEndpointConnectionId", example.applyValue(getVpcEndpointConnectionsResult -> getVpcEndpointConnectionsResult.connections()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:privatelink:getVpcEndpointConnections
     *       Arguments:
     *         serviceId: example_value
     *         status: Connected
     * outputs:
     *   firstPrivatelinkVpcEndpointConnectionId: ${example.connections[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcEndpointConnections.
     * @return A collection of values returned by getVpcEndpointConnections.
     */
    public suspend fun getVpcEndpointConnections(argument: GetVpcEndpointConnectionsPlainArgs): GetVpcEndpointConnectionsResult =
        getVpcEndpointConnectionsResultToKotlin(getVpcEndpointConnectionsPlain(argument.toJava()).await())

    /**
     * @see [getVpcEndpointConnections].
     * @param endpointId The ID of the Vpc Endpoint.
     * @param endpointOwnerId The endpoint owner id.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param serviceId The ID of the Vpc Endpoint Service.
     * @param status The status of Vpc Endpoint Connection. Valid Values: `Connected`, `Connecting`, `Deleted`, `Deleting`, `Disconnected`, `Disconnecting`, `Pending` and `ServiceDeleted`.
     * @return A collection of values returned by getVpcEndpointConnections.
     */
    public suspend fun getVpcEndpointConnections(
        endpointId: String? = null,
        endpointOwnerId: Int? = null,
        outputFile: String? = null,
        serviceId: String,
        status: String? = null,
    ): GetVpcEndpointConnectionsResult {
        val argument = GetVpcEndpointConnectionsPlainArgs(
            endpointId = endpointId,
            endpointOwnerId = endpointOwnerId,
            outputFile = outputFile,
            serviceId = serviceId,
            status = status,
        )
        return getVpcEndpointConnectionsResultToKotlin(getVpcEndpointConnectionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcEndpointConnections].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;privatelink&#46;kotlin&#46;inputs&#46;GetVpcEndpointConnectionsPlainArgs].
     * @return A collection of values returned by getVpcEndpointConnections.
     */
    public suspend fun getVpcEndpointConnections(argument: suspend GetVpcEndpointConnectionsPlainArgsBuilder.() -> Unit): GetVpcEndpointConnectionsResult {
        val builder = GetVpcEndpointConnectionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcEndpointConnectionsResultToKotlin(getVpcEndpointConnectionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Privatelink Vpc Endpoint Service Resources of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.110.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.privatelink.getVpcEndpointServiceResources({
     *     serviceId: "epsrv-gw8ii1xxxx",
     * });
     * export const firstPrivatelinkVpcEndpointServiceResourceId = example.then(example => example.resources?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.privatelink.get_vpc_endpoint_service_resources(service_id="epsrv-gw8ii1xxxx")
     * pulumi.export("firstPrivatelinkVpcEndpointServiceResourceId", example.resources[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.PrivateLink.GetVpcEndpointServiceResources.Invoke(new()
     *     {
     *         ServiceId = "epsrv-gw8ii1xxxx",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstPrivatelinkVpcEndpointServiceResourceId"] = example&#46;Apply(getVpcEndpointServiceResourcesResult => getVpcEndpointServiceResourcesResult&#46;Resources[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/privatelink"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := privatelink.GetVpcEndpointServiceResources(ctx, &privatelink.GetVpcEndpointServiceResourcesArgs{
     * 			ServiceId: "epsrv-gw8ii1xxxx",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstPrivatelinkVpcEndpointServiceResourceId", example.Resources[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.privatelink.PrivatelinkFunctions;
     * import com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServiceResourcesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = PrivatelinkFunctions.getVpcEndpointServiceResources(GetVpcEndpointServiceResourcesArgs.builder()
     *             .serviceId("epsrv-gw8ii1xxxx")
     *             .build());
     *         ctx.export("firstPrivatelinkVpcEndpointServiceResourceId", example.applyValue(getVpcEndpointServiceResourcesResult -> getVpcEndpointServiceResourcesResult.resources()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:privatelink:getVpcEndpointServiceResources
     *       Arguments:
     *         serviceId: epsrv-gw8ii1xxxx
     * outputs:
     *   firstPrivatelinkVpcEndpointServiceResourceId: ${example.resources[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcEndpointServiceResources.
     * @return A collection of values returned by getVpcEndpointServiceResources.
     */
    public suspend fun getVpcEndpointServiceResources(argument: GetVpcEndpointServiceResourcesPlainArgs): GetVpcEndpointServiceResourcesResult =
        getVpcEndpointServiceResourcesResultToKotlin(getVpcEndpointServiceResourcesPlain(argument.toJava()).await())

    /**
     * @see [getVpcEndpointServiceResources].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param serviceId The ID of Vpc Endpoint Service.
     * @return A collection of values returned by getVpcEndpointServiceResources.
     */
    public suspend fun getVpcEndpointServiceResources(outputFile: String? = null, serviceId: String): GetVpcEndpointServiceResourcesResult {
        val argument = GetVpcEndpointServiceResourcesPlainArgs(
            outputFile = outputFile,
            serviceId = serviceId,
        )
        return getVpcEndpointServiceResourcesResultToKotlin(getVpcEndpointServiceResourcesPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcEndpointServiceResources].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;privatelink&#46;kotlin&#46;inputs&#46;GetVpcEndpointServiceResourcesPlainArgs].
     * @return A collection of values returned by getVpcEndpointServiceResources.
     */
    public suspend fun getVpcEndpointServiceResources(argument: suspend GetVpcEndpointServiceResourcesPlainArgsBuilder.() -> Unit): GetVpcEndpointServiceResourcesResult {
        val builder = GetVpcEndpointServiceResourcesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcEndpointServiceResourcesResultToKotlin(getVpcEndpointServiceResourcesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Privatelink Vpc Endpoint Service Users of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.110.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.privatelink.getVpcEndpointServiceUsers({
     *     serviceId: "epsrv-gw81c6vxxxxxx",
     * });
     * export const firstPrivatelinkVpcEndpointServiceUserId = example.then(example => example.users?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.privatelink.get_vpc_endpoint_service_users(service_id="epsrv-gw81c6vxxxxxx")
     * pulumi.export("firstPrivatelinkVpcEndpointServiceUserId", example.users[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.PrivateLink.GetVpcEndpointServiceUsers.Invoke(new()
     *     {
     *         ServiceId = "epsrv-gw81c6vxxxxxx",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstPrivatelinkVpcEndpointServiceUserId"] = example&#46;Apply(getVpcEndpointServiceUsersResult => getVpcEndpointServiceUsersResult&#46;Users[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/privatelink"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := privatelink.GetVpcEndpointServiceUsers(ctx, &privatelink.GetVpcEndpointServiceUsersArgs{
     * 			ServiceId: "epsrv-gw81c6vxxxxxx",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstPrivatelinkVpcEndpointServiceUserId", example.Users[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.privatelink.PrivatelinkFunctions;
     * import com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServiceUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = PrivatelinkFunctions.getVpcEndpointServiceUsers(GetVpcEndpointServiceUsersArgs.builder()
     *             .serviceId("epsrv-gw81c6vxxxxxx")
     *             .build());
     *         ctx.export("firstPrivatelinkVpcEndpointServiceUserId", example.applyValue(getVpcEndpointServiceUsersResult -> getVpcEndpointServiceUsersResult.users()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:privatelink:getVpcEndpointServiceUsers
     *       Arguments:
     *         serviceId: epsrv-gw81c6vxxxxxx
     * outputs:
     *   firstPrivatelinkVpcEndpointServiceUserId: ${example.users[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcEndpointServiceUsers.
     * @return A collection of values returned by getVpcEndpointServiceUsers.
     */
    public suspend fun getVpcEndpointServiceUsers(argument: GetVpcEndpointServiceUsersPlainArgs): GetVpcEndpointServiceUsersResult =
        getVpcEndpointServiceUsersResultToKotlin(getVpcEndpointServiceUsersPlain(argument.toJava()).await())

    /**
     * @see [getVpcEndpointServiceUsers].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param serviceId The Id of Vpc Endpoint Service.
     * @param userId The Id of Ram User.
     * @return A collection of values returned by getVpcEndpointServiceUsers.
     */
    public suspend fun getVpcEndpointServiceUsers(
        outputFile: String? = null,
        serviceId: String,
        userId: String? = null,
    ): GetVpcEndpointServiceUsersResult {
        val argument = GetVpcEndpointServiceUsersPlainArgs(
            outputFile = outputFile,
            serviceId = serviceId,
            userId = userId,
        )
        return getVpcEndpointServiceUsersResultToKotlin(getVpcEndpointServiceUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcEndpointServiceUsers].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;privatelink&#46;kotlin&#46;inputs&#46;GetVpcEndpointServiceUsersPlainArgs].
     * @return A collection of values returned by getVpcEndpointServiceUsers.
     */
    public suspend fun getVpcEndpointServiceUsers(argument: suspend GetVpcEndpointServiceUsersPlainArgsBuilder.() -> Unit): GetVpcEndpointServiceUsersResult {
        val builder = GetVpcEndpointServiceUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcEndpointServiceUsersResultToKotlin(getVpcEndpointServiceUsersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Privatelink Vpc Endpoint Services of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.109.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.privatelink.getVpcEndpointServices({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstPrivatelinkVpcEndpointServiceId = example.then(example => example.services?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.privatelink.get_vpc_endpoint_services(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstPrivatelinkVpcEndpointServiceId", example.services[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.PrivateLink.GetVpcEndpointServices.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstPrivatelinkVpcEndpointServiceId"] = example&#46;Apply(getVpcEndpointServicesResult => getVpcEndpointServicesResult&#46;Services[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/privatelink"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := privatelink.GetVpcEndpointServices(ctx, &privatelink.GetVpcEndpointServicesArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstPrivatelinkVpcEndpointServiceId", example.Services[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.privatelink.PrivatelinkFunctions;
     * import com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServicesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = PrivatelinkFunctions.getVpcEndpointServices(GetVpcEndpointServicesArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstPrivatelinkVpcEndpointServiceId", example.applyValue(getVpcEndpointServicesResult -> getVpcEndpointServicesResult.services()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:privatelink:getVpcEndpointServices
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstPrivatelinkVpcEndpointServiceId: ${example.services[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcEndpointServices.
     * @return A collection of values returned by getVpcEndpointServices.
     */
    public suspend fun getVpcEndpointServices(argument: GetVpcEndpointServicesPlainArgs): GetVpcEndpointServicesResult =
        getVpcEndpointServicesResultToKotlin(getVpcEndpointServicesPlain(argument.toJava()).await())

    /**
     * @see [getVpcEndpointServices].
     * @param autoAcceptConnection Whether to automatically accept terminal node connections.
     * @param ids A list of Vpc Endpoint Service IDs.
     * @param nameRegex A regex string to filter results by Vpc Endpoint Service name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param serviceBusinessStatus The business status of the terminal node service. Valid Value: `Normal`, `FinancialLocked` and `SecurityLocked`.
     * @param status The Status of Vpc Endpoint Service. Valid Value: `Active`, `Creating`, `Deleted`, `Deleting` and `Pending`.
     * @param vpcEndpointServiceName The name of Vpc Endpoint Service.
     * @return A collection of values returned by getVpcEndpointServices.
     */
    public suspend fun getVpcEndpointServices(
        autoAcceptConnection: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        serviceBusinessStatus: String? = null,
        status: String? = null,
        vpcEndpointServiceName: String? = null,
    ): GetVpcEndpointServicesResult {
        val argument = GetVpcEndpointServicesPlainArgs(
            autoAcceptConnection = autoAcceptConnection,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            serviceBusinessStatus = serviceBusinessStatus,
            status = status,
            vpcEndpointServiceName = vpcEndpointServiceName,
        )
        return getVpcEndpointServicesResultToKotlin(getVpcEndpointServicesPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcEndpointServices].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;privatelink&#46;kotlin&#46;inputs&#46;GetVpcEndpointServicesPlainArgs].
     * @return A collection of values returned by getVpcEndpointServices.
     */
    public suspend fun getVpcEndpointServices(argument: suspend GetVpcEndpointServicesPlainArgsBuilder.() -> Unit): GetVpcEndpointServicesResult {
        val builder = GetVpcEndpointServicesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcEndpointServicesResultToKotlin(getVpcEndpointServicesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Privatelink Vpc Endpoint Zones of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.111.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.privatelink.getVpcEndpointZones({
     *     endpointId: "ep-gw8boxxxxx",
     * });
     * export const firstPrivatelinkVpcEndpointZoneId = example.then(example => example.zones?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.privatelink.get_vpc_endpoint_zones(endpoint_id="ep-gw8boxxxxx")
     * pulumi.export("firstPrivatelinkVpcEndpointZoneId", example.zones[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.PrivateLink.GetVpcEndpointZones.Invoke(new()
     *     {
     *         EndpointId = "ep-gw8boxxxxx",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstPrivatelinkVpcEndpointZoneId"] = example&#46;Apply(getVpcEndpointZonesResult => getVpcEndpointZonesResult&#46;Zones[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/privatelink"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := privatelink.GetVpcEndpointZones(ctx, &privatelink.GetVpcEndpointZonesArgs{
     * 			EndpointId: "ep-gw8boxxxxx",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstPrivatelinkVpcEndpointZoneId", example.Zones[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.privatelink.PrivatelinkFunctions;
     * import com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = PrivatelinkFunctions.getVpcEndpointZones(GetVpcEndpointZonesArgs.builder()
     *             .endpointId("ep-gw8boxxxxx")
     *             .build());
     *         ctx.export("firstPrivatelinkVpcEndpointZoneId", example.applyValue(getVpcEndpointZonesResult -> getVpcEndpointZonesResult.zones()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:privatelink:getVpcEndpointZones
     *       Arguments:
     *         endpointId: ep-gw8boxxxxx
     * outputs:
     *   firstPrivatelinkVpcEndpointZoneId: ${example.zones[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcEndpointZones.
     * @return A collection of values returned by getVpcEndpointZones.
     */
    public suspend fun getVpcEndpointZones(argument: GetVpcEndpointZonesPlainArgs): GetVpcEndpointZonesResult =
        getVpcEndpointZonesResultToKotlin(getVpcEndpointZonesPlain(argument.toJava()).await())

    /**
     * @see [getVpcEndpointZones].
     * @param endpointId The ID of the Vpc Endpoint.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The Status of Vpc Endpoint Zone. Valid Values: `Connected`, `Connecting`, `Creating`, `Deleted`, `Deleting`, `Disconnected`, `Disconnecting` and `Wait`.
     * @return A collection of values returned by getVpcEndpointZones.
     */
    public suspend fun getVpcEndpointZones(
        endpointId: String,
        outputFile: String? = null,
        status: String? = null,
    ): GetVpcEndpointZonesResult {
        val argument = GetVpcEndpointZonesPlainArgs(
            endpointId = endpointId,
            outputFile = outputFile,
            status = status,
        )
        return getVpcEndpointZonesResultToKotlin(getVpcEndpointZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcEndpointZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;privatelink&#46;kotlin&#46;inputs&#46;GetVpcEndpointZonesPlainArgs].
     * @return A collection of values returned by getVpcEndpointZones.
     */
    public suspend fun getVpcEndpointZones(argument: suspend GetVpcEndpointZonesPlainArgsBuilder.() -> Unit): GetVpcEndpointZonesResult {
        val builder = GetVpcEndpointZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcEndpointZonesResultToKotlin(getVpcEndpointZonesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Privatelink Vpc Endpoints of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.109.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.privatelink.getVpcEndpoints({
     *     ids: ["example_value"],
     *     nameRegex: "the_resource_name",
     * });
     * export const firstPrivatelinkVpcEndpointId = example.then(example => example.endpoints?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.privatelink.get_vpc_endpoints(ids=["example_value"],
     *     name_regex="the_resource_name")
     * pulumi.export("firstPrivatelinkVpcEndpointId", example.endpoints[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.PrivateLink.GetVpcEndpoints.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *         NameRegex = "the_resource_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstPrivatelinkVpcEndpointId"] = example&#46;Apply(getVpcEndpointsResult => getVpcEndpointsResult&#46;Endpoints[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/privatelink"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := privatelink.GetVpcEndpoints(ctx, &privatelink.GetVpcEndpointsArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 			NameRegex: pulumi.StringRef("the_resource_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstPrivatelinkVpcEndpointId", example.Endpoints[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.privatelink.PrivatelinkFunctions;
     * import com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = PrivatelinkFunctions.getVpcEndpoints(GetVpcEndpointsArgs.builder()
     *             .ids("example_value")
     *             .nameRegex("the_resource_name")
     *             .build());
     *         ctx.export("firstPrivatelinkVpcEndpointId", example.applyValue(getVpcEndpointsResult -> getVpcEndpointsResult.endpoints()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:privatelink:getVpcEndpoints
     *       Arguments:
     *         ids:
     *           - example_value
     *         nameRegex: the_resource_name
     * outputs:
     *   firstPrivatelinkVpcEndpointId: ${example.endpoints[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVpcEndpoints.
     * @return A collection of values returned by getVpcEndpoints.
     */
    public suspend fun getVpcEndpoints(argument: GetVpcEndpointsPlainArgs): GetVpcEndpointsResult =
        getVpcEndpointsResultToKotlin(getVpcEndpointsPlain(argument.toJava()).await())

    /**
     * @see [getVpcEndpoints].
     * @param connectionStatus The status of Connection.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Vpc Endpoint IDs.
     * @param nameRegex A regex string to filter results by Vpc Endpoint name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param serviceName The name of the terminal node service associated with the terminal node.
     * @param status The status of Vpc Endpoint.
     * @param vpcEndpointName The name of Vpc Endpoint.
     * @param vpcId The private network to which the terminal node belongs..
     * @return A collection of values returned by getVpcEndpoints.
     */
    public suspend fun getVpcEndpoints(
        connectionStatus: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        serviceName: String? = null,
        status: String? = null,
        vpcEndpointName: String? = null,
        vpcId: String? = null,
    ): GetVpcEndpointsResult {
        val argument = GetVpcEndpointsPlainArgs(
            connectionStatus = connectionStatus,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            serviceName = serviceName,
            status = status,
            vpcEndpointName = vpcEndpointName,
            vpcId = vpcId,
        )
        return getVpcEndpointsResultToKotlin(getVpcEndpointsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcEndpoints].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;privatelink&#46;kotlin&#46;inputs&#46;GetVpcEndpointsPlainArgs].
     * @return A collection of values returned by getVpcEndpoints.
     */
    public suspend fun getVpcEndpoints(argument: suspend GetVpcEndpointsPlainArgsBuilder.() -> Unit): GetVpcEndpointsResult {
        val builder = GetVpcEndpointsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcEndpointsResultToKotlin(getVpcEndpointsPlain(builtArgument.toJava()).await())
    }
}
