@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin

import com.pulumi.alicloud.privatelink.VpcEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Private Link Vpc Endpoint resource.
 * For information about Private Link Vpc Endpoint and how to use it, see [What is Vpc Endpoint](https://www.alibabacloud.com/help/en/privatelink/latest/api-privatelink-2020-04-15-createvpcendpoint).
 * > **NOTE:** Available since v1.109.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultbFzA4a = new alicloud.vpc.Network("defaultbFzA4a", {
 *     description: "example-terraform",
 *     cidrBlock: "172.16.0.0/12",
 *     vpcName: name,
 * });
 * const default1FTFrP = new alicloud.ecs.SecurityGroup("default1FTFrP", {
 *     name: name,
 *     vpcId: defaultbFzA4a.id,
 * });
 * const defaultjljY5S = new alicloud.ecs.SecurityGroup("defaultjljY5S", {
 *     name: name,
 *     vpcId: defaultbFzA4a.id,
 * });
 * const defaultVpcEndpoint = new alicloud.privatelink.VpcEndpoint("default", {
 *     endpointDescription: name,
 *     vpcEndpointName: name,
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     endpointType: "Interface",
 *     vpcId: defaultbFzA4a.id,
 *     serviceName: "com.aliyuncs.privatelink.ap-southeast-5.oss",
 *     dryRun: false,
 *     zonePrivateIpAddressCount: 1,
 *     policyDocument: JSON.stringify({
 *         Version: "1",
 *         Statement: [{
 *             Effect: "Allow",
 *             Action: ["*"],
 *             Resource: ["*"],
 *             Principal: "*",
 *         }],
 *     }),
 *     securityGroupIds: [default1FTFrP&#46;id],
 *     serviceId: "epsrv-k1apjysze8u1l9t6uyg9",
 *     protectedEnabled: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * defaultb_fz_a4a = alicloud.vpc.Network("defaultbFzA4a",
 *     description="example-terraform",
 *     cidr_block="172.16.0.0/12",
 *     vpc_name=name)
 * default1_ft_fr_p = alicloud.ecs.SecurityGroup("default1FTFrP",
 *     name=name,
 *     vpc_id=defaultb_fz_a4a.id)
 * defaultjlj_y5_s = alicloud.ecs.SecurityGroup("defaultjljY5S",
 *     name=name,
 *     vpc_id=defaultb_fz_a4a.id)
 * default_vpc_endpoint = alicloud.privatelink.VpcEndpoint("default",
 *     endpoint_description=name,
 *     vpc_endpoint_name=name,
 *     resource_group_id=default.ids[0],
 *     endpoint_type="Interface",
 *     vpc_id=defaultb_fz_a4a.id,
 *     service_name="com.aliyuncs.privatelink.ap-southeast-5.oss",
 *     dry_run=False,
 *     zone_private_ip_address_count=1,
 *     policy_document=json.dumps({
 *         "Version": "1",
 *         "Statement": [{
 *             "Effect": "Allow",
 *             "Action": ["*"],
 *             "Resource": ["*"],
 *             "Principal": "*",
 *         }],
 *     }),
 *     security_group_ids=[default1_ft_fr_p&#46;id],
 *     service_id="epsrv-k1apjysze8u1l9t6uyg9",
 *     protected_enabled=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultbFzA4a = new AliCloud.Vpc.Network("defaultbFzA4a", new()
 *     {
 *         Description = "example-terraform",
 *         CidrBlock = "172.16.0.0/12",
 *         VpcName = name,
 *     });
 *     var default1FTFrP = new AliCloud.Ecs.SecurityGroup("default1FTFrP", new()
 *     {
 *         Name = name,
 *         VpcId = defaultbFzA4a.Id,
 *     });
 *     var defaultjljY5S = new AliCloud.Ecs.SecurityGroup("defaultjljY5S", new()
 *     {
 *         Name = name,
 *         VpcId = defaultbFzA4a.Id,
 *     });
 *     var defaultVpcEndpoint = new AliCloud.PrivateLink.VpcEndpoint("default", new()
 *     {
 *         EndpointDescription = name,
 *         VpcEndpointName = name,
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         EndpointType = "Interface",
 *         VpcId = defaultbFzA4a.Id,
 *         ServiceName = "com.aliyuncs.privatelink.ap-southeast-5.oss",
 *         DryRun = false,
 *         ZonePrivateIpAddressCount = 1,
 *         PolicyDocument = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "1",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Effect"] = "Allow",
 *                     ["Action"] = new[]
 *                     {
 *                         "*",
 *                     },
 *                     ["Resource"] = new[]
 *                     {
 *                         "*",
 *                     },
 *                     ["Principal"] = "*",
 *                 },
 *             },
 *         }),
 *         SecurityGroupIds = new[]
 *         {
 *             default1FTFrP.Id,
 *         },
 *         ServiceId = "epsrv-k1apjysze8u1l9t6uyg9",
 *         ProtectedEnabled = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/privatelink"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultbFzA4a, err := vpc.NewNetwork(ctx, "defaultbFzA4a", &vpc.NetworkArgs{
 * 			Description: pulumi.String("example-terraform"),
 * 			CidrBlock:   pulumi.String("172.16.0.0/12"),
 * 			VpcName:     pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default1FTFrP, err := ecs.NewSecurityGroup(ctx, "default1FTFrP", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultbFzA4a.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroup(ctx, "defaultjljY5S", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(name),
 * 			VpcId: defaultbFzA4a.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "1",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Effect": "Allow",
 * 					"Action": []string{
 * 						"*",
 * 					},
 * 					"Resource": []string{
 * 						"*",
 * 					},
 * 					"Principal": "*",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = privatelink.NewVpcEndpoint(ctx, "default", &privatelink.VpcEndpointArgs{
 * 			EndpointDescription:       pulumi.String(name),
 * 			VpcEndpointName:           pulumi.String(name),
 * 			ResourceGroupId:           pulumi.String(_default.Ids[0]),
 * 			EndpointType:              pulumi.String("Interface"),
 * 			VpcId:                     defaultbFzA4a.ID(),
 * 			ServiceName:               pulumi.String("com.aliyuncs.privatelink.ap-southeast-5.oss"),
 * 			DryRun:                    pulumi.Bool(false),
 * 			ZonePrivateIpAddressCount: pulumi.Int(1),
 * 			PolicyDocument:            pulumi.String(json0),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				default1FTFrP.ID(),
 * 			},
 * 			ServiceId:        pulumi.String("epsrv-k1apjysze8u1l9t6uyg9"),
 * 			ProtectedEnabled: pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.privatelink.VpcEndpoint;
 * import com.pulumi.alicloud.privatelink.VpcEndpointArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultbFzA4a = new Network("defaultbFzA4a", NetworkArgs.builder()
 *             .description("example-terraform")
 *             .cidrBlock("172.16.0.0/12")
 *             .vpcName(name)
 *             .build());
 *         var default1FTFrP = new SecurityGroup("default1FTFrP", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultbFzA4a.id())
 *             .build());
 *         var defaultjljY5S = new SecurityGroup("defaultjljY5S", SecurityGroupArgs.builder()
 *             .name(name)
 *             .vpcId(defaultbFzA4a.id())
 *             .build());
 *         var defaultVpcEndpoint = new VpcEndpoint("defaultVpcEndpoint", VpcEndpointArgs.builder()
 *             .endpointDescription(name)
 *             .vpcEndpointName(name)
 *             .resourceGroupId(default_.ids()[0])
 *             .endpointType("Interface")
 *             .vpcId(defaultbFzA4a.id())
 *             .serviceName("com.aliyuncs.privatelink.ap-southeast-5.oss")
 *             .dryRun("false")
 *             .zonePrivateIpAddressCount("1")
 *             .policyDocument(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "1"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", jsonArray("*")),
 *                         jsonProperty("Resource", jsonArray("*")),
 *                         jsonProperty("Principal", "*")
 *                     )))
 *                 )))
 *             .securityGroupIds(default1FTFrP.id())
 *             .serviceId("epsrv-k1apjysze8u1l9t6uyg9")
 *             .protectedEnabled("false")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultbFzA4a:
 *     type: alicloud:vpc:Network
 *     properties:
 *       description: example-terraform
 *       cidrBlock: 172.16.0.0/12
 *       vpcName: ${name}
 *   default1FTFrP:
 *     type: alicloud:ecs:SecurityGroup
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultbFzA4a.id}
 *   defaultjljY5S:
 *     type: alicloud:ecs:SecurityGroup
 *     properties:
 *       name: ${name}
 *       vpcId: ${defaultbFzA4a.id}
 *   defaultVpcEndpoint:
 *     type: alicloud:privatelink:VpcEndpoint
 *     name: default
 *     properties:
 *       endpointDescription: ${name}
 *       vpcEndpointName: ${name}
 *       resourceGroupId: ${default.ids[0]}
 *       endpointType: Interface
 *       vpcId: ${defaultbFzA4a.id}
 *       serviceName: com.aliyuncs.privatelink.ap-southeast-5.oss
 *       dryRun: 'false'
 *       zonePrivateIpAddressCount: '1'
 *       policyDocument:
 *         fn::toJSON:
 *           Version: '1'
 *           Statement:
 *             - Effect: Allow
 *               Action:
 *                 - '*'
 *               Resource:
 *                 - '*'
 *               Principal: '*'
 *       securityGroupIds:
 *         - ${default1FTFrP.id}
 *       serviceId: epsrv-k1apjysze8u1l9t6uyg9
 *       protectedEnabled: 'false'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Private Link Vpc Endpoint can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:privatelink/vpcEndpoint:VpcEndpoint example <id>
 * ```
 * @property dryRun Specifies whether to perform only a dry run, without performing the actual request. Valid values:
 * - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
 * - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
 * @property endpointDescription The description of the endpoint.
 * @property endpointType The endpoint type. Only the value: Interface, indicating the Interface endpoint. You can add the service resource types of Application Load Balancer (ALB), Classic Load Balancer (CLB), and Network Load Balancer (NLB).
 * @property policyDocument RAM access policies.
 * @property protectedEnabled Specifies whether to enable user authentication. This parameter is available in Security Token Service (STS) mode. Valid values:
 * - **true**: enables user authentication. After user authentication is enabled, only the user who creates the endpoint can modify or delete the endpoint in STS mode.
 * - **false (default)**: disables user authentication.
 * @property resourceGroupId The resource group ID.
 * @property securityGroupIds The ID of the security group that is associated with the endpoint ENI. The security group can be used to control data transfer between the VPC and the endpoint ENI.The endpoint can be associated with up to 10 security groups.
 * @property serviceId The ID of the endpoint service with which the endpoint is associated.
 * @property serviceName The name of the endpoint service with which the endpoint is associated.
 * @property tags The list of tags.
 * @property vpcEndpointName The name of the endpoint.
 * @property vpcId The ID of the VPC to which the endpoint belongs.
 * @property zonePrivateIpAddressCount The number of private IP addresses that are assigned to an elastic network interface (ENI) in each zone. Only 1 is returned.
 */
public data class VpcEndpointArgs(
    public val dryRun: Output<Boolean>? = null,
    public val endpointDescription: Output<String>? = null,
    public val endpointType: Output<String>? = null,
    public val policyDocument: Output<String>? = null,
    public val protectedEnabled: Output<Boolean>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val serviceId: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcEndpointName: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val zonePrivateIpAddressCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.privatelink.VpcEndpointArgs> {
    override fun toJava(): com.pulumi.alicloud.privatelink.VpcEndpointArgs =
        com.pulumi.alicloud.privatelink.VpcEndpointArgs.builder()
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .endpointDescription(endpointDescription?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType?.applyValue({ args0 -> args0 }))
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 }))
            .protectedEnabled(protectedEnabled?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serviceId(serviceId?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcEndpointName(vpcEndpointName?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .zonePrivateIpAddressCount(zonePrivateIpAddressCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcEndpointArgs].
 */
@PulumiTagMarker
public class VpcEndpointArgsBuilder internal constructor() {
    private var dryRun: Output<Boolean>? = null

    private var endpointDescription: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var policyDocument: Output<String>? = null

    private var protectedEnabled: Output<Boolean>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var serviceId: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcEndpointName: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var zonePrivateIpAddressCount: Output<Int>? = null

    /**
     * @param value Specifies whether to perform only a dry run, without performing the actual request. Valid values:
     * - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
     * - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
     */
    @JvmName("qauqyfkfyskbmhgp")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The description of the endpoint.
     */
    @JvmName("oxulyeauyaqciwhi")
    public suspend fun endpointDescription(`value`: Output<String>) {
        this.endpointDescription = value
    }

    /**
     * @param value The endpoint type. Only the value: Interface, indicating the Interface endpoint. You can add the service resource types of Application Load Balancer (ALB), Classic Load Balancer (CLB), and Network Load Balancer (NLB).
     */
    @JvmName("ocmwwcjjlamvxwai")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value RAM access policies.
     */
    @JvmName("hoxaugjecixqwghf")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value Specifies whether to enable user authentication. This parameter is available in Security Token Service (STS) mode. Valid values:
     * - **true**: enables user authentication. After user authentication is enabled, only the user who creates the endpoint can modify or delete the endpoint in STS mode.
     * - **false (default)**: disables user authentication.
     */
    @JvmName("tnpiwicoqfafjsga")
    public suspend fun protectedEnabled(`value`: Output<Boolean>) {
        this.protectedEnabled = value
    }

    /**
     * @param value The resource group ID.
     */
    @JvmName("fsvauwciqkmnfmmi")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The ID of the security group that is associated with the endpoint ENI. The security group can be used to control data transfer between the VPC and the endpoint ENI.The endpoint can be associated with up to 10 security groups.
     */
    @JvmName("hlmcgssfxnghmqpf")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("alabecihkrfrrisn")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The ID of the security group that is associated with the endpoint ENI. The security group can be used to control data transfer between the VPC and the endpoint ENI.The endpoint can be associated with up to 10 security groups.
     */
    @JvmName("aqkrcekcmdxgfhed")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The ID of the endpoint service with which the endpoint is associated.
     */
    @JvmName("iunyifblqrgadysk")
    public suspend fun serviceId(`value`: Output<String>) {
        this.serviceId = value
    }

    /**
     * @param value The name of the endpoint service with which the endpoint is associated.
     */
    @JvmName("haibwvdkfwpoourj")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The list of tags.
     */
    @JvmName("odqokjvtpsbpdgib")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the endpoint.
     */
    @JvmName("rijpmwovfcjqojgv")
    public suspend fun vpcEndpointName(`value`: Output<String>) {
        this.vpcEndpointName = value
    }

    /**
     * @param value The ID of the VPC to which the endpoint belongs.
     */
    @JvmName("hjplqxcilclwvbvk")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The number of private IP addresses that are assigned to an elastic network interface (ENI) in each zone. Only 1 is returned.
     */
    @JvmName("vryfrysqmtkbiclr")
    public suspend fun zonePrivateIpAddressCount(`value`: Output<Int>) {
        this.zonePrivateIpAddressCount = value
    }

    /**
     * @param value Specifies whether to perform only a dry run, without performing the actual request. Valid values:
     * - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
     * - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
     */
    @JvmName("cpevidldqrxtapll")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The description of the endpoint.
     */
    @JvmName("unpqqqkufcgqavjf")
    public suspend fun endpointDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointDescription = mapped
    }

    /**
     * @param value The endpoint type. Only the value: Interface, indicating the Interface endpoint. You can add the service resource types of Application Load Balancer (ALB), Classic Load Balancer (CLB), and Network Load Balancer (NLB).
     */
    @JvmName("qlrolneevgkdclfv")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value RAM access policies.
     */
    @JvmName("vsbjihqdxrfrpiwd")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    /**
     * @param value Specifies whether to enable user authentication. This parameter is available in Security Token Service (STS) mode. Valid values:
     * - **true**: enables user authentication. After user authentication is enabled, only the user who creates the endpoint can modify or delete the endpoint in STS mode.
     * - **false (default)**: disables user authentication.
     */
    @JvmName("wkmwiormdtouwubj")
    public suspend fun protectedEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedEnabled = mapped
    }

    /**
     * @param value The resource group ID.
     */
    @JvmName("yyqxgrvfsxexnshe")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The ID of the security group that is associated with the endpoint ENI. The security group can be used to control data transfer between the VPC and the endpoint ENI.The endpoint can be associated with up to 10 security groups.
     */
    @JvmName("ukhtibicwvawfmhu")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The ID of the security group that is associated with the endpoint ENI. The security group can be used to control data transfer between the VPC and the endpoint ENI.The endpoint can be associated with up to 10 security groups.
     */
    @JvmName("itmelfxedylytulk")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The ID of the endpoint service with which the endpoint is associated.
     */
    @JvmName("mwlwfshmbxmumumw")
    public suspend fun serviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceId = mapped
    }

    /**
     * @param value The name of the endpoint service with which the endpoint is associated.
     */
    @JvmName("clmxlfcjcfjbkonb")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The list of tags.
     */
    @JvmName("nocnptsjvucsmxah")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The list of tags.
     */
    @JvmName("dedekxboejhoucaf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the endpoint.
     */
    @JvmName("fcvdkhcdgxtahemr")
    public suspend fun vpcEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointName = mapped
    }

    /**
     * @param value The ID of the VPC to which the endpoint belongs.
     */
    @JvmName("xsfyubwbfomjpeun")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The number of private IP addresses that are assigned to an elastic network interface (ENI) in each zone. Only 1 is returned.
     */
    @JvmName("eesbeqbpjjsuuikc")
    public suspend fun zonePrivateIpAddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zonePrivateIpAddressCount = mapped
    }

    internal fun build(): VpcEndpointArgs = VpcEndpointArgs(
        dryRun = dryRun,
        endpointDescription = endpointDescription,
        endpointType = endpointType,
        policyDocument = policyDocument,
        protectedEnabled = protectedEnabled,
        resourceGroupId = resourceGroupId,
        securityGroupIds = securityGroupIds,
        serviceId = serviceId,
        serviceName = serviceName,
        tags = tags,
        vpcEndpointName = vpcEndpointName,
        vpcId = vpcId,
        zonePrivateIpAddressCount = zonePrivateIpAddressCount,
    )
}
