@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VpcEndpointService].
 */
@PulumiTagMarker
public class VpcEndpointServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcEndpointServiceArgs = VpcEndpointServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcEndpointServiceArgsBuilder.() -> Unit) {
        val builder = VpcEndpointServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcEndpointService {
        val builtJavaResource =
            com.pulumi.alicloud.privatelink.VpcEndpointService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VpcEndpointService(builtJavaResource)
    }
}

/**
 * Provides a Private Link Vpc Endpoint Service resource.
 * For information about Private Link Vpc Endpoint Service and how to use it, see [What is Vpc Endpoint Service](https://www.alibabacloud.com/help/en/privatelink/latest/api-privatelink-2020-04-15-createvpcendpointservice).
 * > **NOTE:** Available since v1.109.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const example = new alicloud.privatelink.VpcEndpointService("example", {
 *     serviceDescription: name,
 *     connectBandwidth: 103,
 *     autoAcceptConnection: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * example = alicloud.privatelink.VpcEndpointService("example",
 *     service_description=name,
 *     connect_bandwidth=103,
 *     auto_accept_connection=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var example = new AliCloud.PrivateLink.VpcEndpointService("example", new()
 *     {
 *         ServiceDescription = name,
 *         ConnectBandwidth = 103,
 *         AutoAcceptConnection = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/privatelink"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := privatelink.NewVpcEndpointService(ctx, "example", &privatelink.VpcEndpointServiceArgs{
 * 			ServiceDescription:   pulumi.String(name),
 * 			ConnectBandwidth:     pulumi.Int(103),
 * 			AutoAcceptConnection: pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.privatelink.VpcEndpointService;
 * import com.pulumi.alicloud.privatelink.VpcEndpointServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var example = new VpcEndpointService("example", VpcEndpointServiceArgs.builder()
 *             .serviceDescription(name)
 *             .connectBandwidth(103)
 *             .autoAcceptConnection(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   example:
 *     type: alicloud:privatelink:VpcEndpointService
 *     properties:
 *       serviceDescription: ${name}
 *       connectBandwidth: 103
 *       autoAcceptConnection: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Private Link Vpc Endpoint Service can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:privatelink/vpcEndpointService:VpcEndpointService example <id>
 * ```
 */
public class VpcEndpointService internal constructor(
    override val javaResource: com.pulumi.alicloud.privatelink.VpcEndpointService,
) : KotlinCustomResource(javaResource, VpcEndpointServiceMapper) {
    /**
     * Indicates whether the endpoint service automatically accepts endpoint connection requests. Valid values:
     * - **true**
     * - **false**.
     */
    public val autoAcceptConnection: Output<Boolean>?
        get() = javaResource.autoAcceptConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The default bandwidth of the endpoint connection. Valid values: 100 to 10240. Unit: Mbit/s.
     */
    public val connectBandwidth: Output<Int>
        get() = javaResource.connectBandwidth().applyValue({ args0 -> args0 })

    /**
     * The time when the endpoint service was created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to perform only a dry run, without performing the actual request.
     * - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
     * - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The payer of the endpoint service. Valid values:
     * - **Endpoint**: the service consumer.
     * - **EndpointService**: the service provider.
     */
    public val payer: Output<String>
        get() = javaResource.payer().applyValue({ args0 -> args0 })

    /**
     * The resource group ID.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The service state of the endpoint service.
     */
    public val serviceBusinessStatus: Output<String>
        get() = javaResource.serviceBusinessStatus().applyValue({ args0 -> args0 })

    /**
     * The description of the endpoint service.
     */
    public val serviceDescription: Output<String>?
        get() = javaResource.serviceDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The domain name of the endpoint service.
     */
    public val serviceDomain: Output<String>
        get() = javaResource.serviceDomain().applyValue({ args0 -> args0 })

    /**
     * Service resource type, value:
     * - **slb**: indicates that the service resource type is Classic Load Balancer (CLB).
     * - **alb**: indicates that the service resource type is Application Load Balancer (ALB).
     * - **nlb**: indicates that the service resource type is Network Load Balancer (NLB).
     */
    public val serviceResourceType: Output<String>
        get() = javaResource.serviceResourceType().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable IPv6 for the endpoint service. Valid values:
     * - **true**
     * - **false (default)**.
     */
    public val serviceSupportIpv6: Output<Boolean>
        get() = javaResource.serviceSupportIpv6().applyValue({ args0 -> args0 })

    /**
     * The state of the endpoint service.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The list of tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The name of the endpoint service.
     */
    public val vpcEndpointServiceName: Output<String>
        get() = javaResource.vpcEndpointServiceName().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to first resolve the domain name of the nearest endpoint that is associated with the endpoint service. Valid values:
     * - **true**
     * - **false (default)**.
     */
    public val zoneAffinityEnabled: Output<Boolean>
        get() = javaResource.zoneAffinityEnabled().applyValue({ args0 -> args0 })
}

public object VpcEndpointServiceMapper : ResourceMapper<VpcEndpointService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.privatelink.VpcEndpointService::class == javaResource::class

    override fun map(javaResource: Resource): VpcEndpointService = VpcEndpointService(
        javaResource as
            com.pulumi.alicloud.privatelink.VpcEndpointService,
    )
}

/**
 * @see [VpcEndpointService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcEndpointService].
 */
public suspend fun vpcEndpointService(
    name: String,
    block: suspend VpcEndpointServiceResourceBuilder.() -> Unit,
): VpcEndpointService {
    val builder = VpcEndpointServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcEndpointService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcEndpointService(name: String): VpcEndpointService {
    val builder = VpcEndpointServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
