@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin

import com.pulumi.alicloud.privatelink.VpcEndpointServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Private Link Vpc Endpoint Service resource.
 * For information about Private Link Vpc Endpoint Service and how to use it, see [What is Vpc Endpoint Service](https://www.alibabacloud.com/help/en/privatelink/latest/api-privatelink-2020-04-15-createvpcendpointservice).
 * > **NOTE:** Available since v1.109.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const example = new alicloud.privatelink.VpcEndpointService("example", {
 *     serviceDescription: name,
 *     connectBandwidth: 103,
 *     autoAcceptConnection: false,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * example = alicloud.privatelink.VpcEndpointService("example",
 *     service_description=name,
 *     connect_bandwidth=103,
 *     auto_accept_connection=False)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var example = new AliCloud.PrivateLink.VpcEndpointService("example", new()
 *     {
 *         ServiceDescription = name,
 *         ConnectBandwidth = 103,
 *         AutoAcceptConnection = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/privatelink"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := privatelink.NewVpcEndpointService(ctx, "example", &privatelink.VpcEndpointServiceArgs{
 * 			ServiceDescription:   pulumi.String(name),
 * 			ConnectBandwidth:     pulumi.Int(103),
 * 			AutoAcceptConnection: pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.privatelink.VpcEndpointService;
 * import com.pulumi.alicloud.privatelink.VpcEndpointServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var example = new VpcEndpointService("example", VpcEndpointServiceArgs.builder()
 *             .serviceDescription(name)
 *             .connectBandwidth(103)
 *             .autoAcceptConnection(false)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   example:
 *     type: alicloud:privatelink:VpcEndpointService
 *     properties:
 *       serviceDescription: ${name}
 *       connectBandwidth: 103
 *       autoAcceptConnection: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Private Link Vpc Endpoint Service can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:privatelink/vpcEndpointService:VpcEndpointService example <id>
 * ```
 * @property autoAcceptConnection Indicates whether the endpoint service automatically accepts endpoint connection requests. Valid values:
 * - **true**
 * - **false**.
 * @property connectBandwidth The default bandwidth of the endpoint connection. Valid values: 100 to 10240. Unit: Mbit/s.
 * @property dryRun Specifies whether to perform only a dry run, without performing the actual request.
 * - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
 * - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
 * @property payer The payer of the endpoint service. Valid values:
 * - **Endpoint**: the service consumer.
 * - **EndpointService**: the service provider.
 * @property resourceGroupId The resource group ID.
 * @property serviceDescription The description of the endpoint service.
 * @property serviceResourceType Service resource type, value:
 * - **slb**: indicates that the service resource type is Classic Load Balancer (CLB).
 * - **alb**: indicates that the service resource type is Application Load Balancer (ALB).
 * - **nlb**: indicates that the service resource type is Network Load Balancer (NLB).
 * @property serviceSupportIpv6 Specifies whether to enable IPv6 for the endpoint service. Valid values:
 * - **true**
 * - **false (default)**.
 * @property tags The list of tags.
 * @property zoneAffinityEnabled Specifies whether to first resolve the domain name of the nearest endpoint that is associated with the endpoint service. Valid values:
 * - **true**
 * - **false (default)**.
 */
public data class VpcEndpointServiceArgs(
    public val autoAcceptConnection: Output<Boolean>? = null,
    public val connectBandwidth: Output<Int>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val payer: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val serviceDescription: Output<String>? = null,
    public val serviceResourceType: Output<String>? = null,
    public val serviceSupportIpv6: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneAffinityEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.privatelink.VpcEndpointServiceArgs> {
    override fun toJava(): com.pulumi.alicloud.privatelink.VpcEndpointServiceArgs =
        com.pulumi.alicloud.privatelink.VpcEndpointServiceArgs.builder()
            .autoAcceptConnection(autoAcceptConnection?.applyValue({ args0 -> args0 }))
            .connectBandwidth(connectBandwidth?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .payer(payer?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .serviceDescription(serviceDescription?.applyValue({ args0 -> args0 }))
            .serviceResourceType(serviceResourceType?.applyValue({ args0 -> args0 }))
            .serviceSupportIpv6(serviceSupportIpv6?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneAffinityEnabled(zoneAffinityEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcEndpointServiceArgs].
 */
@PulumiTagMarker
public class VpcEndpointServiceArgsBuilder internal constructor() {
    private var autoAcceptConnection: Output<Boolean>? = null

    private var connectBandwidth: Output<Int>? = null

    private var dryRun: Output<Boolean>? = null

    private var payer: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var serviceDescription: Output<String>? = null

    private var serviceResourceType: Output<String>? = null

    private var serviceSupportIpv6: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneAffinityEnabled: Output<Boolean>? = null

    /**
     * @param value Indicates whether the endpoint service automatically accepts endpoint connection requests. Valid values:
     * - **true**
     * - **false**.
     */
    @JvmName("soqkqnbuljknmhly")
    public suspend fun autoAcceptConnection(`value`: Output<Boolean>) {
        this.autoAcceptConnection = value
    }

    /**
     * @param value The default bandwidth of the endpoint connection. Valid values: 100 to 10240. Unit: Mbit/s.
     */
    @JvmName("cdffjnnbpwikpbff")
    public suspend fun connectBandwidth(`value`: Output<Int>) {
        this.connectBandwidth = value
    }

    /**
     * @param value Specifies whether to perform only a dry run, without performing the actual request.
     * - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
     * - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
     */
    @JvmName("cygjkvpuwprhusqf")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The payer of the endpoint service. Valid values:
     * - **Endpoint**: the service consumer.
     * - **EndpointService**: the service provider.
     */
    @JvmName("vjegqfygmebpshii")
    public suspend fun payer(`value`: Output<String>) {
        this.payer = value
    }

    /**
     * @param value The resource group ID.
     */
    @JvmName("lufmfwjepwiylssv")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The description of the endpoint service.
     */
    @JvmName("mrlrgkiowpmnwcsq")
    public suspend fun serviceDescription(`value`: Output<String>) {
        this.serviceDescription = value
    }

    /**
     * @param value Service resource type, value:
     * - **slb**: indicates that the service resource type is Classic Load Balancer (CLB).
     * - **alb**: indicates that the service resource type is Application Load Balancer (ALB).
     * - **nlb**: indicates that the service resource type is Network Load Balancer (NLB).
     */
    @JvmName("dvtjnqkyqxeimemf")
    public suspend fun serviceResourceType(`value`: Output<String>) {
        this.serviceResourceType = value
    }

    /**
     * @param value Specifies whether to enable IPv6 for the endpoint service. Valid values:
     * - **true**
     * - **false (default)**.
     */
    @JvmName("xnhepolibetbqxhr")
    public suspend fun serviceSupportIpv6(`value`: Output<Boolean>) {
        this.serviceSupportIpv6 = value
    }

    /**
     * @param value The list of tags.
     */
    @JvmName("qoetqdamufopyehy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies whether to first resolve the domain name of the nearest endpoint that is associated with the endpoint service. Valid values:
     * - **true**
     * - **false (default)**.
     */
    @JvmName("qtkpdslltpexphdr")
    public suspend fun zoneAffinityEnabled(`value`: Output<Boolean>) {
        this.zoneAffinityEnabled = value
    }

    /**
     * @param value Indicates whether the endpoint service automatically accepts endpoint connection requests. Valid values:
     * - **true**
     * - **false**.
     */
    @JvmName("ehsglkryocdgduel")
    public suspend fun autoAcceptConnection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAcceptConnection = mapped
    }

    /**
     * @param value The default bandwidth of the endpoint connection. Valid values: 100 to 10240. Unit: Mbit/s.
     */
    @JvmName("ulijgchbrepyqvja")
    public suspend fun connectBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectBandwidth = mapped
    }

    /**
     * @param value Specifies whether to perform only a dry run, without performing the actual request.
     * - **true**: performs only a dry run. The system checks the request for potential issues, including missing parameter values, incorrect request syntax, and service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
     * - **false (default)**: performs a dry run and performs the actual request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
     */
    @JvmName("masosnscyhxjfeyi")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The payer of the endpoint service. Valid values:
     * - **Endpoint**: the service consumer.
     * - **EndpointService**: the service provider.
     */
    @JvmName("suwvogbfudtptnrx")
    public suspend fun payer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payer = mapped
    }

    /**
     * @param value The resource group ID.
     */
    @JvmName("aklyovejfxsyqmas")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The description of the endpoint service.
     */
    @JvmName("wesaomutpkkmrcju")
    public suspend fun serviceDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceDescription = mapped
    }

    /**
     * @param value Service resource type, value:
     * - **slb**: indicates that the service resource type is Classic Load Balancer (CLB).
     * - **alb**: indicates that the service resource type is Application Load Balancer (ALB).
     * - **nlb**: indicates that the service resource type is Network Load Balancer (NLB).
     */
    @JvmName("cekgityesnojunvh")
    public suspend fun serviceResourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceResourceType = mapped
    }

    /**
     * @param value Specifies whether to enable IPv6 for the endpoint service. Valid values:
     * - **true**
     * - **false (default)**.
     */
    @JvmName("jdbnaqnyybipcllh")
    public suspend fun serviceSupportIpv6(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceSupportIpv6 = mapped
    }

    /**
     * @param value The list of tags.
     */
    @JvmName("gserlretolfofgkw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The list of tags.
     */
    @JvmName("fhvfdkdodfxscgdd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies whether to first resolve the domain name of the nearest endpoint that is associated with the endpoint service. Valid values:
     * - **true**
     * - **false (default)**.
     */
    @JvmName("elnytluxwtpcffsy")
    public suspend fun zoneAffinityEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneAffinityEnabled = mapped
    }

    internal fun build(): VpcEndpointServiceArgs = VpcEndpointServiceArgs(
        autoAcceptConnection = autoAcceptConnection,
        connectBandwidth = connectBandwidth,
        dryRun = dryRun,
        payer = payer,
        resourceGroupId = resourceGroupId,
        serviceDescription = serviceDescription,
        serviceResourceType = serviceResourceType,
        serviceSupportIpv6 = serviceSupportIpv6,
        tags = tags,
        zoneAffinityEnabled = zoneAffinityEnabled,
    )
}
