@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.inputs

import com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointConnectionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcEndpointConnections.
 * @property endpointId The ID of the Vpc Endpoint.
 * @property endpointOwnerId The endpoint owner id.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property serviceId The ID of the Vpc Endpoint Service.
 * @property status The status of Vpc Endpoint Connection. Valid Values: `Connected`, `Connecting`, `Deleted`, `Deleting`, `Disconnected`, `Disconnecting`, `Pending` and `ServiceDeleted`.
 */
public data class GetVpcEndpointConnectionsPlainArgs(
    public val endpointId: String? = null,
    public val endpointOwnerId: Int? = null,
    public val outputFile: String? = null,
    public val serviceId: String,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointConnectionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointConnectionsPlainArgs =
        com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointConnectionsPlainArgs.builder()
            .endpointId(endpointId?.let({ args0 -> args0 }))
            .endpointOwnerId(endpointOwnerId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .serviceId(serviceId.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcEndpointConnectionsPlainArgs].
 */
@PulumiTagMarker
public class GetVpcEndpointConnectionsPlainArgsBuilder internal constructor() {
    private var endpointId: String? = null

    private var endpointOwnerId: Int? = null

    private var outputFile: String? = null

    private var serviceId: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the Vpc Endpoint.
     */
    @JvmName("dhgwtldmmwnelqtn")
    public suspend fun endpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointId = mapped
    }

    /**
     * @param value The endpoint owner id.
     */
    @JvmName("cmdqvivswnawssib")
    public suspend fun endpointOwnerId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endpointOwnerId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tfhogyiwtbdjfger")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the Vpc Endpoint Service.
     */
    @JvmName("cjbyvmnlvxckhelu")
    public suspend fun serviceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceId = mapped
    }

    /**
     * @param value The status of Vpc Endpoint Connection. Valid Values: `Connected`, `Connecting`, `Deleted`, `Deleting`, `Disconnected`, `Disconnecting`, `Pending` and `ServiceDeleted`.
     */
    @JvmName("xjstxapwftxdwewj")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetVpcEndpointConnectionsPlainArgs = GetVpcEndpointConnectionsPlainArgs(
        endpointId = endpointId,
        endpointOwnerId = endpointOwnerId,
        outputFile = outputFile,
        serviceId = serviceId ?: throw PulumiNullFieldException("serviceId"),
        status = status,
    )
}
