@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.inputs

import com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServiceResourcesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcEndpointServiceResources.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property serviceId The ID of Vpc Endpoint Service.
 */
public data class GetVpcEndpointServiceResourcesPlainArgs(
    public val outputFile: String? = null,
    public val serviceId: String,
) :
    ConvertibleToJava<com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServiceResourcesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServiceResourcesPlainArgs =
        com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServiceResourcesPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .serviceId(serviceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcEndpointServiceResourcesPlainArgs].
 */
@PulumiTagMarker
public class GetVpcEndpointServiceResourcesPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    private var serviceId: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lfyjyideiwfofkkp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of Vpc Endpoint Service.
     */
    @JvmName("bjvpiimfbhgpbaah")
    public suspend fun serviceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceId = mapped
    }

    internal fun build(): GetVpcEndpointServiceResourcesPlainArgs =
        GetVpcEndpointServiceResourcesPlainArgs(
            outputFile = outputFile,
            serviceId = serviceId ?: throw PulumiNullFieldException("serviceId"),
        )
}
