@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.inputs

import com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServiceUsersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcEndpointServiceUsers.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property serviceId The Id of Vpc Endpoint Service.
 * @property userId The Id of Ram User.
 */
public data class GetVpcEndpointServiceUsersPlainArgs(
    public val outputFile: String? = null,
    public val serviceId: String,
    public val userId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServiceUsersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServiceUsersPlainArgs = com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServiceUsersPlainArgs.builder()
        .outputFile(outputFile?.let({ args0 -> args0 }))
        .serviceId(serviceId.let({ args0 -> args0 }))
        .userId(userId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcEndpointServiceUsersPlainArgs].
 */
@PulumiTagMarker
public class GetVpcEndpointServiceUsersPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    private var serviceId: String? = null

    private var userId: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xxbmtjohosgxgmnp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Id of Vpc Endpoint Service.
     */
    @JvmName("gcqkjoffpeomhgax")
    public suspend fun serviceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceId = mapped
    }

    /**
     * @param value The Id of Ram User.
     */
    @JvmName("oswlxfdilietomcf")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userId = mapped
    }

    internal fun build(): GetVpcEndpointServiceUsersPlainArgs = GetVpcEndpointServiceUsersPlainArgs(
        outputFile = outputFile,
        serviceId = serviceId ?: throw PulumiNullFieldException("serviceId"),
        userId = userId,
    )
}
