@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.inputs

import com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServicesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcEndpointServices.
 * @property autoAcceptConnection Whether to automatically accept terminal node connections.
 * @property ids A list of Vpc Endpoint Service IDs.
 * @property nameRegex A regex string to filter results by Vpc Endpoint Service name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property serviceBusinessStatus The business status of the terminal node service. Valid Value: `Normal`, `FinancialLocked` and `SecurityLocked`.
 * @property status The Status of Vpc Endpoint Service. Valid Value: `Active`, `Creating`, `Deleted`, `Deleting` and `Pending`.
 * @property vpcEndpointServiceName The name of Vpc Endpoint Service.
 */
public data class GetVpcEndpointServicesPlainArgs(
    public val autoAcceptConnection: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val serviceBusinessStatus: String? = null,
    public val status: String? = null,
    public val vpcEndpointServiceName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServicesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServicesPlainArgs =
        com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointServicesPlainArgs.builder()
            .autoAcceptConnection(autoAcceptConnection?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .serviceBusinessStatus(serviceBusinessStatus?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpcEndpointServiceName(vpcEndpointServiceName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcEndpointServicesPlainArgs].
 */
@PulumiTagMarker
public class GetVpcEndpointServicesPlainArgsBuilder internal constructor() {
    private var autoAcceptConnection: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var serviceBusinessStatus: String? = null

    private var status: String? = null

    private var vpcEndpointServiceName: String? = null

    /**
     * @param value Whether to automatically accept terminal node connections.
     */
    @JvmName("ukmshhfmkkrurdpm")
    public suspend fun autoAcceptConnection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.autoAcceptConnection = mapped
    }

    /**
     * @param value A list of Vpc Endpoint Service IDs.
     */
    @JvmName("jmurdxbhhjfqswar")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Vpc Endpoint Service IDs.
     */
    @JvmName("rgqjmckrymtctysu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Vpc Endpoint Service name.
     */
    @JvmName("rlpxtcbcdbmjykhf")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("sfewbcslekgxnwug")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The business status of the terminal node service. Valid Value: `Normal`, `FinancialLocked` and `SecurityLocked`.
     */
    @JvmName("foaiwhtufcdomkwr")
    public suspend fun serviceBusinessStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serviceBusinessStatus = mapped
    }

    /**
     * @param value The Status of Vpc Endpoint Service. Valid Value: `Active`, `Creating`, `Deleted`, `Deleting` and `Pending`.
     */
    @JvmName("smxkwduwrsvdljnl")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The name of Vpc Endpoint Service.
     */
    @JvmName("rrimclwtrxdeqpvi")
    public suspend fun vpcEndpointServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcEndpointServiceName = mapped
    }

    internal fun build(): GetVpcEndpointServicesPlainArgs = GetVpcEndpointServicesPlainArgs(
        autoAcceptConnection = autoAcceptConnection,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        serviceBusinessStatus = serviceBusinessStatus,
        status = status,
        vpcEndpointServiceName = vpcEndpointServiceName,
    )
}
