@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.inputs

import com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointZonesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcEndpointZones.
 * @property endpointId The ID of the Vpc Endpoint.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The Status of Vpc Endpoint Zone. Valid Values: `Connected`, `Connecting`, `Creating`, `Deleted`, `Deleting`, `Disconnected`, `Disconnecting` and `Wait`.
 */
public data class GetVpcEndpointZonesPlainArgs(
    public val endpointId: String,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointZonesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointZonesPlainArgs =
        com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointZonesPlainArgs.builder()
            .endpointId(endpointId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcEndpointZonesPlainArgs].
 */
@PulumiTagMarker
public class GetVpcEndpointZonesPlainArgsBuilder internal constructor() {
    private var endpointId: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The ID of the Vpc Endpoint.
     */
    @JvmName("gxajtklufbakfldq")
    public suspend fun endpointId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endpointId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("sufveujjsfcbjecc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Status of Vpc Endpoint Zone. Valid Values: `Connected`, `Connecting`, `Creating`, `Deleted`, `Deleting`, `Disconnected`, `Disconnecting` and `Wait`.
     */
    @JvmName("htkcnkyqrutbwojs")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetVpcEndpointZonesPlainArgs = GetVpcEndpointZonesPlainArgs(
        endpointId = endpointId ?: throw PulumiNullFieldException("endpointId"),
        outputFile = outputFile,
        status = status,
    )
}
