@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.inputs

import com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVpcEndpoints.
 * @property connectionStatus The status of Connection.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Vpc Endpoint IDs.
 * @property nameRegex A regex string to filter results by Vpc Endpoint name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property serviceName The name of the terminal node service associated with the terminal node.
 * @property status The status of Vpc Endpoint.
 * @property vpcEndpointName The name of Vpc Endpoint.
 * @property vpcId The private network to which the terminal node belongs..
 */
public data class GetVpcEndpointsPlainArgs(
    public val connectionStatus: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val serviceName: String? = null,
    public val status: String? = null,
    public val vpcEndpointName: String? = null,
    public val vpcId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointsPlainArgs =
        com.pulumi.alicloud.privatelink.inputs.GetVpcEndpointsPlainArgs.builder()
            .connectionStatus(connectionStatus?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .serviceName(serviceName?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vpcEndpointName(vpcEndpointName?.let({ args0 -> args0 }))
            .vpcId(vpcId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpcEndpointsPlainArgs].
 */
@PulumiTagMarker
public class GetVpcEndpointsPlainArgsBuilder internal constructor() {
    private var connectionStatus: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var serviceName: String? = null

    private var status: String? = null

    private var vpcEndpointName: String? = null

    private var vpcId: String? = null

    /**
     * @param value The status of Connection.
     */
    @JvmName("vnfwlivjpqlobxgf")
    public suspend fun connectionStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.connectionStatus = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("yjtnjhnufxjvwhnh")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Vpc Endpoint IDs.
     */
    @JvmName("llyrwvhemtscvrwi")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Vpc Endpoint IDs.
     */
    @JvmName("ewolgisemdoacafl")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Vpc Endpoint name.
     */
    @JvmName("fbpaarrswjoaajwx")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("fhawfmyhqlkxgxrj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The name of the terminal node service associated with the terminal node.
     */
    @JvmName("kwhnpmlhnhyfvvhs")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The status of Vpc Endpoint.
     */
    @JvmName("rjycgsdrnxwvnrpj")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The name of Vpc Endpoint.
     */
    @JvmName("adjighywoikrxkoq")
    public suspend fun vpcEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcEndpointName = mapped
    }

    /**
     * @param value The private network to which the terminal node belongs..
     */
    @JvmName("jeljuubwdwcteytb")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpcId = mapped
    }

    internal fun build(): GetVpcEndpointsPlainArgs = GetVpcEndpointsPlainArgs(
        connectionStatus = connectionStatus,
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        serviceName = serviceName,
        status = status,
        vpcEndpointName = vpcEndpointName,
        vpcId = vpcId,
    )
}
