@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcEndpointConnections.
 * @property connections
 * @property endpointId
 * @property endpointOwnerId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property serviceId
 * @property status
 */
public data class GetVpcEndpointConnectionsResult(
    public val connections: List<GetVpcEndpointConnectionsConnection>,
    public val endpointId: String? = null,
    public val endpointOwnerId: Int? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val serviceId: String,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.privatelink.outputs.GetVpcEndpointConnectionsResult): GetVpcEndpointConnectionsResult = GetVpcEndpointConnectionsResult(
            connections = javaType.connections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointConnectionsConnection.Companion.toKotlin(args0)
                })
            }),
            endpointId = javaType.endpointId().map({ args0 -> args0 }).orElse(null),
            endpointOwnerId = javaType.endpointOwnerId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            serviceId = javaType.serviceId(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
