@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcEndpointServiceUsers.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property serviceId
 * @property userId
 * @property users
 */
public data class GetVpcEndpointServiceUsersResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val serviceId: String,
    public val userId: String? = null,
    public val users: List<GetVpcEndpointServiceUsersUser>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.privatelink.outputs.GetVpcEndpointServiceUsersResult): GetVpcEndpointServiceUsersResult = GetVpcEndpointServiceUsersResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            serviceId = javaType.serviceId(),
            userId = javaType.userId().map({ args0 -> args0 }).orElse(null),
            users = javaType.users().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointServiceUsersUser.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
