@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcEndpointServices.
 * @property autoAcceptConnection
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property serviceBusinessStatus
 * @property services
 * @property status
 * @property vpcEndpointServiceName
 */
public data class GetVpcEndpointServicesResult(
    public val autoAcceptConnection: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val serviceBusinessStatus: String? = null,
    public val services: List<GetVpcEndpointServicesService>,
    public val status: String? = null,
    public val vpcEndpointServiceName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.privatelink.outputs.GetVpcEndpointServicesResult): GetVpcEndpointServicesResult = GetVpcEndpointServicesResult(
            autoAcceptConnection = javaType.autoAcceptConnection().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            serviceBusinessStatus = javaType.serviceBusinessStatus().map({ args0 -> args0 }).orElse(null),
            services = javaType.services().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointServicesService.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vpcEndpointServiceName = javaType.vpcEndpointServiceName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
