@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoAcceptConnection Whether to automatically accept terminal node connections..
 * @property connectBandwidth The connection bandwidth.
 * @property id The ID of the Vpc Endpoint Service.
 * @property serviceBusinessStatus The business status of the terminal node service..
 * @property serviceDescription The description of the terminal node service.
 * @property serviceDomain The domain of service.
 * @property serviceId The ID of the Vpc Endpoint Service.
 * @property status The Status of Vpc Endpoint Service.
 * @property vpcEndpointServiceName The name of Vpc Endpoint Service.
 */
public data class GetVpcEndpointServicesService(
    public val autoAcceptConnection: Boolean,
    public val connectBandwidth: Int,
    public val id: String,
    public val serviceBusinessStatus: String,
    public val serviceDescription: String,
    public val serviceDomain: String,
    public val serviceId: String,
    public val status: String,
    public val vpcEndpointServiceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.privatelink.outputs.GetVpcEndpointServicesService): GetVpcEndpointServicesService = GetVpcEndpointServicesService(
            autoAcceptConnection = javaType.autoAcceptConnection(),
            connectBandwidth = javaType.connectBandwidth(),
            id = javaType.id(),
            serviceBusinessStatus = javaType.serviceBusinessStatus(),
            serviceDescription = javaType.serviceDescription(),
            serviceDomain = javaType.serviceDomain(),
            serviceId = javaType.serviceId(),
            status = javaType.status(),
            vpcEndpointServiceName = javaType.vpcEndpointServiceName(),
        )
    }
}
