@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcEndpointZones.
 * @property endpointId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property status
 * @property zones
 */
public data class GetVpcEndpointZonesResult(
    public val endpointId: String,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val zones: List<GetVpcEndpointZonesZone>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.privatelink.outputs.GetVpcEndpointZonesResult): GetVpcEndpointZonesResult = GetVpcEndpointZonesResult(
            endpointId = javaType.endpointId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            zones = javaType.zones().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointZonesZone.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
