@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property eniId Terminal node network card.
 * @property eniIp IP address of the terminal node network card.
 * @property id The ID of the Vpc Endpoint Zone.
 * @property status The Status of Vpc Endpoint Zone..
 * @property vswitchId The vSwitch id.
 * @property zoneDomain The Zone Domain.
 * @property zoneId The Zone Id.
 */
public data class GetVpcEndpointZonesZone(
    public val eniId: String,
    public val eniIp: String,
    public val id: String,
    public val status: String,
    public val vswitchId: String,
    public val zoneDomain: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.privatelink.outputs.GetVpcEndpointZonesZone): GetVpcEndpointZonesZone = GetVpcEndpointZonesZone(
            eniId = javaType.eniId(),
            eniIp = javaType.eniIp(),
            id = javaType.id(),
            status = javaType.status(),
            vswitchId = javaType.vswitchId(),
            zoneDomain = javaType.zoneDomain(),
            zoneId = javaType.zoneId(),
        )
    }
}
