@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bandwidth The Bandwidth.
 * @property connectionStatus The status of Connection.
 * @property endpointBusinessStatus The status of Endpoint Business.
 * @property endpointDescription The description of Vpc Endpoint.
 * @property endpointDomain The Endpoint Domain.
 * @property endpointId The ID of the Vpc Endpoint.
 * @property id The ID of the Vpc Endpoint.
 * @property securityGroupIds The security group associated with the terminal node network card.
 * @property serviceId The terminal node service associated with the terminal node.
 * @property serviceName The name of the terminal node service associated with the terminal node.
 * @property status The status of Vpc Endpoint.
 * @property vpcEndpointName The name of Vpc Endpoint.
 * @property vpcId The private network to which the terminal node belongs.
 */
public data class GetVpcEndpointsEndpoint(
    public val bandwidth: Int,
    public val connectionStatus: String,
    public val endpointBusinessStatus: String,
    public val endpointDescription: String,
    public val endpointDomain: String,
    public val endpointId: String,
    public val id: String,
    public val securityGroupIds: List<String>,
    public val serviceId: String,
    public val serviceName: String,
    public val status: String,
    public val vpcEndpointName: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.privatelink.outputs.GetVpcEndpointsEndpoint): GetVpcEndpointsEndpoint = GetVpcEndpointsEndpoint(
            bandwidth = javaType.bandwidth(),
            connectionStatus = javaType.connectionStatus(),
            endpointBusinessStatus = javaType.endpointBusinessStatus(),
            endpointDescription = javaType.endpointDescription(),
            endpointDomain = javaType.endpointDomain(),
            endpointId = javaType.endpointId(),
            id = javaType.id(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            serviceId = javaType.serviceId(),
            serviceName = javaType.serviceName(),
            status = javaType.status(),
            vpcEndpointName = javaType.vpcEndpointName(),
            vpcId = javaType.vpcId(),
        )
    }
}
