@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.privatelink.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVpcEndpoints.
 * @property connectionStatus
 * @property enableDetails
 * @property endpoints
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property serviceName
 * @property status
 * @property vpcEndpointName
 * @property vpcId
 */
public data class GetVpcEndpointsResult(
    public val connectionStatus: String? = null,
    public val enableDetails: Boolean? = null,
    public val endpoints: List<GetVpcEndpointsEndpoint>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val serviceName: String? = null,
    public val status: String? = null,
    public val vpcEndpointName: String? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.privatelink.outputs.GetVpcEndpointsResult): GetVpcEndpointsResult = GetVpcEndpointsResult(
            connectionStatus = javaType.connectionStatus().map({ args0 -> args0 }).orElse(null),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.privatelink.kotlin.outputs.GetVpcEndpointsEndpoint.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            serviceName = javaType.serviceName().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vpcEndpointName = javaType.vpcEndpointName().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
