@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.alicloud.pvtz.kotlin.outputs.EndpointIpConfig
import com.pulumi.alicloud.pvtz.kotlin.outputs.EndpointIpConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Endpoint].
 */
@PulumiTagMarker
public class EndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointArgs = EndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointArgsBuilder.() -> Unit) {
        val builder = EndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Endpoint {
        val builtJavaResource = com.pulumi.alicloud.pvtz.Endpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Endpoint(builtJavaResource)
    }
}

/**
 * Provides a Private Zone Endpoint resource.
 * For information about Private Zone Endpoint and how to use it, see [What is Endpoint](https://www.alibabacloud.com/help/en/privatezone/latest/add-endpoint).
 * > **NOTE:** Available since v1.143.0.
 * ## Import
 * Private Zone Endpoint can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:pvtz/endpoint:Endpoint example <id>
 * ```
 */
public class Endpoint internal constructor(
    override val javaResource: com.pulumi.alicloud.pvtz.Endpoint,
) : KotlinCustomResource(javaResource, EndpointMapper) {
    /**
     * The name of the resource.
     */
    public val endpointName: Output<String>
        get() = javaResource.endpointName().applyValue({ args0 -> args0 })

    /**
     * The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
     */
    public val ipConfigs: Output<List<EndpointIpConfig>>
        get() = javaResource.ipConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The ID of the Security Group.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The VPC ID.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The Region of the VPC.
     */
    public val vpcRegionId: Output<String>
        get() = javaResource.vpcRegionId().applyValue({ args0 -> args0 })
}

public object EndpointMapper : ResourceMapper<Endpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.pvtz.Endpoint::class == javaResource::class

    override fun map(javaResource: Resource): Endpoint = Endpoint(
        javaResource as
            com.pulumi.alicloud.pvtz.Endpoint,
    )
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Endpoint].
 */
public suspend fun endpoint(name: String, block: suspend EndpointResourceBuilder.() -> Unit): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpoint(name: String): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
