@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.alicloud.pvtz.EndpointArgs.builder
import com.pulumi.alicloud.pvtz.kotlin.inputs.EndpointIpConfigArgs
import com.pulumi.alicloud.pvtz.kotlin.inputs.EndpointIpConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Private Zone Endpoint resource.
 * For information about Private Zone Endpoint and how to use it, see [What is Endpoint](https://www.alibabacloud.com/help/en/privatezone/latest/add-endpoint).
 * > **NOTE:** Available since v1.143.0.
 * ## Import
 * Private Zone Endpoint can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:pvtz/endpoint:Endpoint example <id>
 * ```
 * @property endpointName The name of the resource.
 * @property ipConfigs The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
 * @property securityGroupId The ID of the Security Group.
 * @property vpcId The VPC ID.
 * @property vpcRegionId The Region of the VPC.
 */
public data class EndpointArgs(
    public val endpointName: Output<String>? = null,
    public val ipConfigs: Output<List<EndpointIpConfigArgs>>? = null,
    public val securityGroupId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vpcRegionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.EndpointArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.EndpointArgs =
        com.pulumi.alicloud.pvtz.EndpointArgs.builder()
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .ipConfigs(
                ipConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vpcRegionId(vpcRegionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var endpointName: Output<String>? = null

    private var ipConfigs: Output<List<EndpointIpConfigArgs>>? = null

    private var securityGroupId: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vpcRegionId: Output<String>? = null

    /**
     * @param value The name of the resource.
     */
    @JvmName("kqepqfcehxxnmrmq")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
     */
    @JvmName("afahcjbnkepxdomw")
    public suspend fun ipConfigs(`value`: Output<List<EndpointIpConfigArgs>>) {
        this.ipConfigs = value
    }

    @JvmName("etocsboeixuponfi")
    public suspend fun ipConfigs(vararg values: Output<EndpointIpConfigArgs>) {
        this.ipConfigs = Output.all(values.asList())
    }

    /**
     * @param values The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
     */
    @JvmName("icuuvbkmxhhgkksk")
    public suspend fun ipConfigs(values: List<Output<EndpointIpConfigArgs>>) {
        this.ipConfigs = Output.all(values)
    }

    /**
     * @param value The ID of the Security Group.
     */
    @JvmName("bgaobxxsmysvnvis")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The VPC ID.
     */
    @JvmName("ksbahhwieaslkxof")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The Region of the VPC.
     */
    @JvmName("lwltehufiptgopju")
    public suspend fun vpcRegionId(`value`: Output<String>) {
        this.vpcRegionId = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("wigyxvmodpqsyycd")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
     */
    @JvmName("scbgraaubeejqrri")
    public suspend fun ipConfigs(`value`: List<EndpointIpConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigs = mapped
    }

    /**
     * @param argument The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
     */
    @JvmName("qclqipkjypyfpoxt")
    public suspend fun ipConfigs(argument: List<suspend EndpointIpConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointIpConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigs = mapped
    }

    /**
     * @param argument The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
     */
    @JvmName("ujkborrsbrusxcnq")
    public suspend fun ipConfigs(vararg argument: suspend EndpointIpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EndpointIpConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigs = mapped
    }

    /**
     * @param argument The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
     */
    @JvmName("oqdlphimfenxoxhl")
    public suspend fun ipConfigs(argument: suspend EndpointIpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EndpointIpConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipConfigs = mapped
    }

    /**
     * @param values The Ip Configs. See `ip_configs` below. **NOTE:** In order to ensure high availability, add at least 2 and up to 6.
     */
    @JvmName("htbbqfxsydkewqji")
    public suspend fun ipConfigs(vararg values: EndpointIpConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigs = mapped
    }

    /**
     * @param value The ID of the Security Group.
     */
    @JvmName("kutqydlgufmfvqhp")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The VPC ID.
     */
    @JvmName("uemdonsqanvpjtln")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The Region of the VPC.
     */
    @JvmName("ifkcqxyihfghpgfg")
    public suspend fun vpcRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcRegionId = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        endpointName = endpointName,
        ipConfigs = ipConfigs,
        securityGroupId = securityGroupId,
        vpcId = vpcId,
        vpcRegionId = vpcRegionId,
    )
}
