@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.alicloud.pvtz.PvtzFunctions.getEndpointsPlain
import com.pulumi.alicloud.pvtz.PvtzFunctions.getResolverZonesPlain
import com.pulumi.alicloud.pvtz.PvtzFunctions.getRulesPlain
import com.pulumi.alicloud.pvtz.PvtzFunctions.getServicePlain
import com.pulumi.alicloud.pvtz.PvtzFunctions.getZoneRecordsPlain
import com.pulumi.alicloud.pvtz.PvtzFunctions.getZonesPlain
import com.pulumi.alicloud.pvtz.kotlin.inputs.GetEndpointsPlainArgs
import com.pulumi.alicloud.pvtz.kotlin.inputs.GetEndpointsPlainArgsBuilder
import com.pulumi.alicloud.pvtz.kotlin.inputs.GetResolverZonesPlainArgs
import com.pulumi.alicloud.pvtz.kotlin.inputs.GetResolverZonesPlainArgsBuilder
import com.pulumi.alicloud.pvtz.kotlin.inputs.GetRulesPlainArgs
import com.pulumi.alicloud.pvtz.kotlin.inputs.GetRulesPlainArgsBuilder
import com.pulumi.alicloud.pvtz.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.pvtz.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.pvtz.kotlin.inputs.GetZoneRecordsPlainArgs
import com.pulumi.alicloud.pvtz.kotlin.inputs.GetZoneRecordsPlainArgsBuilder
import com.pulumi.alicloud.pvtz.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.pvtz.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.pvtz.kotlin.outputs.GetEndpointsResult
import com.pulumi.alicloud.pvtz.kotlin.outputs.GetResolverZonesResult
import com.pulumi.alicloud.pvtz.kotlin.outputs.GetRulesResult
import com.pulumi.alicloud.pvtz.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.pvtz.kotlin.outputs.GetZoneRecordsResult
import com.pulumi.alicloud.pvtz.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.pvtz.kotlin.outputs.GetEndpointsResult.Companion.toKotlin as getEndpointsResultToKotlin
import com.pulumi.alicloud.pvtz.kotlin.outputs.GetResolverZonesResult.Companion.toKotlin as getResolverZonesResultToKotlin
import com.pulumi.alicloud.pvtz.kotlin.outputs.GetRulesResult.Companion.toKotlin as getRulesResultToKotlin
import com.pulumi.alicloud.pvtz.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.pvtz.kotlin.outputs.GetZoneRecordsResult.Companion.toKotlin as getZoneRecordsResultToKotlin
import com.pulumi.alicloud.pvtz.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object PvtzFunctions {
    /**
     * This data source provides the Pvtz Endpoints of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.143.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.pvtz.getEndpoints({
     *     ids: ["example_id"],
     * });
     * export const pvtzEndpointId1 = ids.then(ids => ids.endpoints?.[0]?.id);
     * const nameRegex = alicloud.pvtz.getEndpoints({
     *     nameRegex: "^my-Endpoint",
     * });
     * export const pvtzEndpointId2 = nameRegex.then(nameRegex => nameRegex.endpoints?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.pvtz.get_endpoints(ids=["example_id"])
     * pulumi.export("pvtzEndpointId1", ids.endpoints[0].id)
     * name_regex = alicloud.pvtz.get_endpoints(name_regex="^my-Endpoint")
     * pulumi.export("pvtzEndpointId2", name_regex.endpoints[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Pvtz.GetEndpoints.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.Pvtz.GetEndpoints.Invoke(new()
     *     {
     *         NameRegex = "^my-Endpoint",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["pvtzEndpointId1"] = ids&#46;Apply(getEndpointsResult => getEndpointsResult&#46;Endpoints[0]?.Id),
     *         ["pvtzEndpointId2"] = nameRegex&#46;Apply(getEndpointsResult => getEndpointsResult&#46;Endpoints[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := pvtz.GetEndpoints(ctx, &pvtz.GetEndpointsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("pvtzEndpointId1", ids.Endpoints[0].Id)
     * 		nameRegex, err := pvtz.GetEndpoints(ctx, &pvtz.GetEndpointsArgs{
     * 			NameRegex: pulumi.StringRef("^my-Endpoint"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("pvtzEndpointId2", nameRegex.Endpoints[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.pvtz.PvtzFunctions;
     * import com.pulumi.alicloud.pvtz.inputs.GetEndpointsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = PvtzFunctions.getEndpoints(GetEndpointsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("pvtzEndpointId1", ids.applyValue(getEndpointsResult -> getEndpointsResult.endpoints()[0].id()));
     *         final var nameRegex = PvtzFunctions.getEndpoints(GetEndpointsArgs.builder()
     *             .nameRegex("^my-Endpoint")
     *             .build());
     *         ctx.export("pvtzEndpointId2", nameRegex.applyValue(getEndpointsResult -> getEndpointsResult.endpoints()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:pvtz:getEndpoints
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:pvtz:getEndpoints
     *       Arguments:
     *         nameRegex: ^my-Endpoint
     * outputs:
     *   pvtzEndpointId1: ${ids.endpoints[0].id}
     *   pvtzEndpointId2: ${nameRegex.endpoints[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEndpoints.
     * @return A collection of values returned by getEndpoints.
     */
    public suspend fun getEndpoints(argument: GetEndpointsPlainArgs): GetEndpointsResult =
        getEndpointsResultToKotlin(getEndpointsPlain(argument.toJava()).await())

    /**
     * @see [getEndpoints].
     * @param ids A list of Endpoint IDs.
     * @param nameRegex A regex string to filter results by Endpoint name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the resource. Valid values: `CHANGE_FAILED`, `CHANGE_INIT`, `EXCEPTION`, `FAILED`, `INIT`, `SUCCESS`.
     * @return A collection of values returned by getEndpoints.
     */
    public suspend fun getEndpoints(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetEndpointsResult {
        val argument = GetEndpointsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getEndpointsResultToKotlin(getEndpointsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEndpoints].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;pvtz&#46;kotlin&#46;inputs&#46;GetEndpointsPlainArgs].
     * @return A collection of values returned by getEndpoints.
     */
    public suspend fun getEndpoints(argument: suspend GetEndpointsPlainArgsBuilder.() -> Unit): GetEndpointsResult {
        val builder = GetEndpointsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEndpointsResultToKotlin(getEndpointsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the available zones with the Private Zone Resolver of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.143.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.pvtz.getResolverZones({
     *     status: "NORMAL",
     * });
     * export const firstZonesId = _default.then(_default => _default.zones?.[0]?.zoneId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.pvtz.get_resolver_zones(status="NORMAL")
     * pulumi.export("firstZonesId", default.zones[0].zone_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Pvtz.GetResolverZones.Invoke(new()
     *     {
     *         Status = "NORMAL",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstZonesId"] = @default&#46;Apply(@default => @default&#46;Apply(getResolverZonesResult => getResolverZonesResult&#46;Zones[0]?.ZoneId)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := pvtz.GetResolverZones(ctx, &pvtz.GetResolverZonesArgs{
     * 			Status: pulumi.StringRef("NORMAL"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstZonesId", _default.Zones[0].ZoneId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.pvtz.PvtzFunctions;
     * import com.pulumi.alicloud.pvtz.inputs.GetResolverZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = PvtzFunctions.getResolverZones(GetResolverZonesArgs.builder()
     *             .status("NORMAL")
     *             .build());
     *         ctx.export("firstZonesId", default_.zones()[0].zoneId());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:pvtz:getResolverZones
     *       Arguments:
     *         status: NORMAL
     * outputs:
     *   firstZonesId: ${default.zones[0].zoneId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getResolverZones.
     * @return A collection of values returned by getResolverZones.
     */
    public suspend fun getResolverZones(argument: GetResolverZonesPlainArgs): GetResolverZonesResult =
        getResolverZonesResultToKotlin(getResolverZonesPlain(argument.toJava()).await())

    /**
     * @see [getResolverZones].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the Zone. Valid values: `NORMAL`, `SOLD_OUT`.
     * @return A collection of values returned by getResolverZones.
     */
    public suspend fun getResolverZones(outputFile: String? = null, status: String? = null): GetResolverZonesResult {
        val argument = GetResolverZonesPlainArgs(
            outputFile = outputFile,
            status = status,
        )
        return getResolverZonesResultToKotlin(getResolverZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getResolverZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;pvtz&#46;kotlin&#46;inputs&#46;GetResolverZonesPlainArgs].
     * @return A collection of values returned by getResolverZones.
     */
    public suspend fun getResolverZones(argument: suspend GetResolverZonesPlainArgsBuilder.() -> Unit): GetResolverZonesResult {
        val builder = GetResolverZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResolverZonesResultToKotlin(getResolverZonesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the PrivateZone Rules of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.143.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.pvtz.getRules({});
     * export const pvtzRuleId1 = ids.then(ids => ids.rules?.[0]?.id);
     * const nameRegex = alicloud.pvtz.getRules({
     *     nameRegex: "^my-Rule",
     * });
     * export const pvtzRuleId2 = nameRegex.then(nameRegex => nameRegex.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.pvtz.get_rules()
     * pulumi.export("pvtzRuleId1", ids.rules[0].id)
     * name_regex = alicloud.pvtz.get_rules(name_regex="^my-Rule")
     * pulumi.export("pvtzRuleId2", name_regex.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Pvtz.GetRules.Invoke();
     *     var nameRegex = AliCloud.Pvtz.GetRules.Invoke(new()
     *     {
     *         NameRegex = "^my-Rule",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["pvtzRuleId1"] = ids&#46;Apply(getRulesResult => getRulesResult&#46;Rules[0]?.Id),
     *         ["pvtzRuleId2"] = nameRegex&#46;Apply(getRulesResult => getRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := pvtz.GetRules(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("pvtzRuleId1", ids.Rules[0].Id)
     * 		nameRegex, err := pvtz.GetRules(ctx, &pvtz.GetRulesArgs{
     * 			NameRegex: pulumi.StringRef("^my-Rule"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("pvtzRuleId2", nameRegex.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.pvtz.PvtzFunctions;
     * import com.pulumi.alicloud.pvtz.inputs.GetRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = PvtzFunctions.getRules();
     *         ctx.export("pvtzRuleId1", ids.applyValue(getRulesResult -> getRulesResult.rules()[0].id()));
     *         final var nameRegex = PvtzFunctions.getRules(GetRulesArgs.builder()
     *             .nameRegex("^my-Rule")
     *             .build());
     *         ctx.export("pvtzRuleId2", nameRegex.applyValue(getRulesResult -> getRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:pvtz:getRules
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:pvtz:getRules
     *       Arguments:
     *         nameRegex: ^my-Rule
     * outputs:
     *   pvtzRuleId1: ${ids.rules[0].id}
     *   pvtzRuleId2: ${nameRegex.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRules.
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(argument: GetRulesPlainArgs): GetRulesResult =
        getRulesResultToKotlin(getRulesPlain(argument.toJava()).await())

    /**
     * @see [getRules].
     * @param endpointId The ID of the Endpoint.
     * @param ids A list of Rule IDs.
     * @param nameRegex A regex string to filter results by Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(
        endpointId: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetRulesResult {
        val argument = GetRulesPlainArgs(
            endpointId = endpointId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getRulesResultToKotlin(getRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;pvtz&#46;kotlin&#46;inputs&#46;GetRulesPlainArgs].
     * @return A collection of values returned by getRules.
     */
    public suspend fun getRules(argument: suspend GetRulesPlainArgsBuilder.() -> Unit): GetRulesResult {
        val builder = GetRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRulesResultToKotlin(getRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open Private Zone service automatically. If the service has been opened, it will return opened.
     * For information about Priavte Zone and how to use it, see [What is Private Zone](https://www.alibabacloud.com/help/en/product/64583.htm).
     * > **NOTE:** Available in v1.114.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.pvtz.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.pvtz.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Pvtz.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := pvtz.GetService(ctx, &pvtz.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.pvtz.PvtzFunctions;
     * import com.pulumi.alicloud.pvtz.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = PvtzFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:pvtz:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * > **NOTE:** Setting `enable = "On"` to open the Private Zone service that means you have read and agreed the [Private Zone Terms of Service](https://help.aliyun.com/document_detail/65657.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;pvtz&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Private Zone Records resource information owned by an Alibaba Cloud account.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const recordsDs = alicloud.pvtz.getZoneRecords({
     *     zoneId: basic.id,
     *     keyword: foo.value,
     * });
     * export const firstRecordId = recordsDs.then(recordsDs => recordsDs.records?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * records_ds = alicloud.pvtz.get_zone_records(zone_id=basic["id"],
     *     keyword=foo["value"])
     * pulumi.export("firstRecordId", records_ds.records[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var recordsDs = AliCloud.Pvtz.GetZoneRecords.Invoke(new()
     *     {
     *         ZoneId = basic.Id,
     *         Keyword = foo.Value,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstRecordId"] = recordsDs&#46;Apply(getZoneRecordsResult => getZoneRecordsResult&#46;Records[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		recordsDs, err := pvtz.GetZoneRecords(ctx, &pvtz.GetZoneRecordsArgs{
     * 			ZoneId:  basic.Id,
     * 			Keyword: pulumi.StringRef(foo.Value),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstRecordId", recordsDs.Records[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.pvtz.PvtzFunctions;
     * import com.pulumi.alicloud.pvtz.inputs.GetZoneRecordsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var recordsDs = PvtzFunctions.getZoneRecords(GetZoneRecordsArgs.builder()
     *             .zoneId(basic.id())
     *             .keyword(foo.value())
     *             .build());
     *         ctx.export("firstRecordId", recordsDs.applyValue(getZoneRecordsResult -> getZoneRecordsResult.records()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   recordsDs:
     *     fn::invoke:
     *       Function: alicloud:pvtz:getZoneRecords
     *       Arguments:
     *         zoneId: ${basic.id}
     *         keyword: ${foo.value}
     * outputs:
     *   firstRecordId: ${recordsDs.records[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZoneRecords.
     * @return A collection of values returned by getZoneRecords.
     */
    public suspend fun getZoneRecords(argument: GetZoneRecordsPlainArgs): GetZoneRecordsResult =
        getZoneRecordsResultToKotlin(getZoneRecordsPlain(argument.toJava()).await())

    /**
     * @see [getZoneRecords].
     * @param ids A list of Private Zone Record IDs.
     * @param keyword Keyword for record rr and value.
     * @param lang User language.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param searchMode Search mode. Value:
     * - LIKE: fuzzy search.
     * - EXACT: precise search. It is not filled in by default.
     * @param status Resolve record status. Value:
     * - ENABLE: enable resolution.
     * - DISABLE: pause parsing.
     * @param tag It is not filled in by default, and queries the current zone resolution records. Fill in "ecs" to query the host name record list under the VPC associated with the current zone.
     * @param userClientIp User ip.
     * @param zoneId ID of the Private Zone.
     * @return A collection of values returned by getZoneRecords.
     */
    public suspend fun getZoneRecords(
        ids: List<String>? = null,
        keyword: String? = null,
        lang: String? = null,
        outputFile: String? = null,
        searchMode: String? = null,
        status: String? = null,
        tag: String? = null,
        userClientIp: String? = null,
        zoneId: String,
    ): GetZoneRecordsResult {
        val argument = GetZoneRecordsPlainArgs(
            ids = ids,
            keyword = keyword,
            lang = lang,
            outputFile = outputFile,
            searchMode = searchMode,
            status = status,
            tag = tag,
            userClientIp = userClientIp,
            zoneId = zoneId,
        )
        return getZoneRecordsResultToKotlin(getZoneRecordsPlain(argument.toJava()).await())
    }

    /**
     * @see [getZoneRecords].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;pvtz&#46;kotlin&#46;inputs&#46;GetZoneRecordsPlainArgs].
     * @return A collection of values returned by getZoneRecords.
     */
    public suspend fun getZoneRecords(argument: suspend GetZoneRecordsPlainArgsBuilder.() -> Unit): GetZoneRecordsResult {
        val builder = GetZoneRecordsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZoneRecordsResultToKotlin(getZoneRecordsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source lists a number of Private Zones resource information owned by an Alibaba Cloud account.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const pvtzZonesDs = alicloud.pvtz.getZones({
     *     keyword: basic.zoneName,
     * });
     * export const firstZoneId = pvtzZonesDs.then(pvtzZonesDs => pvtzZonesDs.zones?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * pvtz_zones_ds = alicloud.pvtz.get_zones(keyword=basic["zoneName"])
     * pulumi.export("firstZoneId", pvtz_zones_ds.zones[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var pvtzZonesDs = AliCloud.Pvtz.GetZones.Invoke(new()
     *     {
     *         Keyword = basic.ZoneName,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstZoneId"] = pvtzZonesDs&#46;Apply(getZonesResult => getZonesResult&#46;Zones[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		pvtzZonesDs, err := pvtz.GetZones(ctx, &pvtz.GetZonesArgs{
     * 			Keyword: pulumi.StringRef(basic.ZoneName),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstZoneId", pvtzZonesDs.Zones[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.pvtz.PvtzFunctions;
     * import com.pulumi.alicloud.pvtz.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var pvtzZonesDs = PvtzFunctions.getZones(GetZonesArgs.builder()
     *             .keyword(basic.zoneName())
     *             .build());
     *         ctx.export("firstZoneId", pvtzZonesDs.applyValue(getZonesResult -> getZonesResult.zones()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   pvtzZonesDs:
     *     fn::invoke:
     *       Function: alicloud:pvtz:getZones
     *       Arguments:
     *         keyword: ${basic.zoneName}
     * outputs:
     *   firstZoneId: ${pvtzZonesDs.zones[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param enableDetails Default to `false`. Set it to true can output more details.
     * @param ids A list of zone IDs.
     * @param keyword keyword for zone name.
     * @param lang User language.
     * @param nameRegex
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param queryRegionId query_region_id for zone regionId.
     * @param queryVpcId query_vpc_id for zone vpcId.
     * @param resourceGroupId resource_group_id for zone resourceGroupId.
     * @param searchMode Search mode. Value:
     * - LIKE: fuzzy search.
     * - EXACT: precise search. It is not filled in by default.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        keyword: String? = null,
        lang: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        queryRegionId: String? = null,
        queryVpcId: String? = null,
        resourceGroupId: String? = null,
        searchMode: String? = null,
    ): GetZonesResult {
        val argument = GetZonesPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            keyword = keyword,
            lang = lang,
            nameRegex = nameRegex,
            outputFile = outputFile,
            queryRegionId = queryRegionId,
            queryVpcId = queryVpcId,
            resourceGroupId = resourceGroupId,
            searchMode = searchMode,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;pvtz&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
