@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.alicloud.pvtz.RuleArgs.builder
import com.pulumi.alicloud.pvtz.kotlin.inputs.RuleForwardIpArgs
import com.pulumi.alicloud.pvtz.kotlin.inputs.RuleForwardIpArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Private Zone Rule resource.
 * For information about Private Zone Rule and how to use it, see [What is Rule](https://www.alibabacloud.com/help/en/privatezone/latest/add-forwarding-rule).
 * > **NOTE:** Available since v1.143.0.
 * ## Import
 * Private Zone Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:pvtz/rule:Rule example <id>
 * ```
 * @property endpointId The ID of the Endpoint.
 * @property forwardIps Forwarding target. See `forward_ips` below.
 * @property ruleName The name of the resource.
 * @property type The type of the rule. Valid values: `OUTBOUND`.
 * @property zoneName The name of the forwarding zone.
 */
public data class RuleArgs(
    public val endpointId: Output<String>? = null,
    public val forwardIps: Output<List<RuleForwardIpArgs>>? = null,
    public val ruleName: Output<String>? = null,
    public val type: Output<String>? = null,
    public val zoneName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.RuleArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.RuleArgs =
        com.pulumi.alicloud.pvtz.RuleArgs.builder()
            .endpointId(endpointId?.applyValue({ args0 -> args0 }))
            .forwardIps(
                forwardIps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .zoneName(zoneName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleArgs].
 */
@PulumiTagMarker
public class RuleArgsBuilder internal constructor() {
    private var endpointId: Output<String>? = null

    private var forwardIps: Output<List<RuleForwardIpArgs>>? = null

    private var ruleName: Output<String>? = null

    private var type: Output<String>? = null

    private var zoneName: Output<String>? = null

    /**
     * @param value The ID of the Endpoint.
     */
    @JvmName("pdmqaxjojiefqsjt")
    public suspend fun endpointId(`value`: Output<String>) {
        this.endpointId = value
    }

    /**
     * @param value Forwarding target. See `forward_ips` below.
     */
    @JvmName("eggftjiqnvrqcosb")
    public suspend fun forwardIps(`value`: Output<List<RuleForwardIpArgs>>) {
        this.forwardIps = value
    }

    @JvmName("dcffvehjfbfkoqxv")
    public suspend fun forwardIps(vararg values: Output<RuleForwardIpArgs>) {
        this.forwardIps = Output.all(values.asList())
    }

    /**
     * @param values Forwarding target. See `forward_ips` below.
     */
    @JvmName("eptxkxbldbirttgo")
    public suspend fun forwardIps(values: List<Output<RuleForwardIpArgs>>) {
        this.forwardIps = Output.all(values)
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("slvhhhgfaylnjvdb")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The type of the rule. Valid values: `OUTBOUND`.
     */
    @JvmName("cuiufojcrovuaoas")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the forwarding zone.
     */
    @JvmName("xjfbkqkuprgaofaw")
    public suspend fun zoneName(`value`: Output<String>) {
        this.zoneName = value
    }

    /**
     * @param value The ID of the Endpoint.
     */
    @JvmName("eghpoialjxxubpip")
    public suspend fun endpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointId = mapped
    }

    /**
     * @param value Forwarding target. See `forward_ips` below.
     */
    @JvmName("nlketxpqlfdihelt")
    public suspend fun forwardIps(`value`: List<RuleForwardIpArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardIps = mapped
    }

    /**
     * @param argument Forwarding target. See `forward_ips` below.
     */
    @JvmName("daihhmtkvwybcmcr")
    public suspend fun forwardIps(argument: List<suspend RuleForwardIpArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleForwardIpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.forwardIps = mapped
    }

    /**
     * @param argument Forwarding target. See `forward_ips` below.
     */
    @JvmName("wkahkirethukityd")
    public suspend fun forwardIps(vararg argument: suspend RuleForwardIpArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleForwardIpArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.forwardIps = mapped
    }

    /**
     * @param argument Forwarding target. See `forward_ips` below.
     */
    @JvmName("hwlejvhrkivyhvcb")
    public suspend fun forwardIps(argument: suspend RuleForwardIpArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleForwardIpArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.forwardIps = mapped
    }

    /**
     * @param values Forwarding target. See `forward_ips` below.
     */
    @JvmName("hhubqwwohljdwvml")
    public suspend fun forwardIps(vararg values: RuleForwardIpArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwardIps = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("kxdxtvwbrlcubreu")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value The type of the rule. Valid values: `OUTBOUND`.
     */
    @JvmName("nydchrpdibffawmr")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The name of the forwarding zone.
     */
    @JvmName("cyiukuamfqloamex")
    public suspend fun zoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneName = mapped
    }

    internal fun build(): RuleArgs = RuleArgs(
        endpointId = endpointId,
        forwardIps = forwardIps,
        ruleName = ruleName,
        type = type,
        zoneName = zoneName,
    )
}
