@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.alicloud.pvtz.kotlin.outputs.RuleAttachmentVpc
import com.pulumi.alicloud.pvtz.kotlin.outputs.RuleAttachmentVpc.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RuleAttachment].
 */
@PulumiTagMarker
public class RuleAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuleAttachmentArgs = RuleAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuleAttachmentArgsBuilder.() -> Unit) {
        val builder = RuleAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RuleAttachment {
        val builtJavaResource = com.pulumi.alicloud.pvtz.RuleAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RuleAttachment(builtJavaResource)
    }
}

/**
 * Provides a Private Zone Rule Attachment resource.
 * For information about Private Zone Rule Attachment and how to use it, see [What is Rule Attachment](https://www.alibabacloud.com/help/en/doc-detail/177601.htm).
 * > **NOTE:** Available since v1.143.0.
 * ## Import
 * Private Zone Rule Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:pvtz/ruleAttachment:RuleAttachment example <rule_id>
 * ```
 */
public class RuleAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.pvtz.RuleAttachment,
) : KotlinCustomResource(javaResource, RuleAttachmentMapper) {
    /**
     * The ID of the rule.
     */
    public val ruleId: Output<String>
        get() = javaResource.ruleId().applyValue({ args0 -> args0 })

    /**
     * The List of the VPC. See `vpcs` below.
     */
    public val vpcs: Output<List<RuleAttachmentVpc>>
        get() = javaResource.vpcs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object RuleAttachmentMapper : ResourceMapper<RuleAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.pvtz.RuleAttachment::class == javaResource::class

    override fun map(javaResource: Resource): RuleAttachment = RuleAttachment(
        javaResource as
            com.pulumi.alicloud.pvtz.RuleAttachment,
    )
}

/**
 * @see [RuleAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RuleAttachment].
 */
public suspend fun ruleAttachment(
    name: String,
    block: suspend RuleAttachmentResourceBuilder.() -> Unit,
): RuleAttachment {
    val builder = RuleAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RuleAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ruleAttachment(name: String): RuleAttachment {
    val builder = RuleAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
