@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.alicloud.pvtz.RuleAttachmentArgs.builder
import com.pulumi.alicloud.pvtz.kotlin.inputs.RuleAttachmentVpcArgs
import com.pulumi.alicloud.pvtz.kotlin.inputs.RuleAttachmentVpcArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Private Zone Rule Attachment resource.
 * For information about Private Zone Rule Attachment and how to use it, see [What is Rule Attachment](https://www.alibabacloud.com/help/en/doc-detail/177601.htm).
 * > **NOTE:** Available since v1.143.0.
 * ## Import
 * Private Zone Rule Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:pvtz/ruleAttachment:RuleAttachment example <rule_id>
 * ```
 * @property ruleId The ID of the rule.
 * @property vpcs The List of the VPC. See `vpcs` below.
 */
public data class RuleAttachmentArgs(
    public val ruleId: Output<String>? = null,
    public val vpcs: Output<List<RuleAttachmentVpcArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.RuleAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.RuleAttachmentArgs =
        com.pulumi.alicloud.pvtz.RuleAttachmentArgs.builder()
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .vpcs(
                vpcs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleAttachmentArgs].
 */
@PulumiTagMarker
public class RuleAttachmentArgsBuilder internal constructor() {
    private var ruleId: Output<String>? = null

    private var vpcs: Output<List<RuleAttachmentVpcArgs>>? = null

    /**
     * @param value The ID of the rule.
     */
    @JvmName("blfpqplgryrcyydr")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value The List of the VPC. See `vpcs` below.
     */
    @JvmName("gxmpqtldlbmjmuew")
    public suspend fun vpcs(`value`: Output<List<RuleAttachmentVpcArgs>>) {
        this.vpcs = value
    }

    @JvmName("druugjnnxslluyka")
    public suspend fun vpcs(vararg values: Output<RuleAttachmentVpcArgs>) {
        this.vpcs = Output.all(values.asList())
    }

    /**
     * @param values The List of the VPC. See `vpcs` below.
     */
    @JvmName("tvrhabjtaargfrqa")
    public suspend fun vpcs(values: List<Output<RuleAttachmentVpcArgs>>) {
        this.vpcs = Output.all(values)
    }

    /**
     * @param value The ID of the rule.
     */
    @JvmName("yclsoohrsscmdymq")
    public suspend fun ruleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value The List of the VPC. See `vpcs` below.
     */
    @JvmName("polhropqbswejqmi")
    public suspend fun vpcs(`value`: List<RuleAttachmentVpcArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcs = mapped
    }

    /**
     * @param argument The List of the VPC. See `vpcs` below.
     */
    @JvmName("dxkmvatyawpuywbk")
    public suspend fun vpcs(argument: List<suspend RuleAttachmentVpcArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleAttachmentVpcArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpcs = mapped
    }

    /**
     * @param argument The List of the VPC. See `vpcs` below.
     */
    @JvmName("lcqwjncdjhrirmpv")
    public suspend fun vpcs(vararg argument: suspend RuleAttachmentVpcArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleAttachmentVpcArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpcs = mapped
    }

    /**
     * @param argument The List of the VPC. See `vpcs` below.
     */
    @JvmName("fcwhskqojqennbso")
    public suspend fun vpcs(argument: suspend RuleAttachmentVpcArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleAttachmentVpcArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vpcs = mapped
    }

    /**
     * @param values The List of the VPC. See `vpcs` below.
     */
    @JvmName("xvbgppiboqotuwlm")
    public suspend fun vpcs(vararg values: RuleAttachmentVpcArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcs = mapped
    }

    internal fun build(): RuleAttachmentArgs = RuleAttachmentArgs(
        ruleId = ruleId,
        vpcs = vpcs,
    )
}
