@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserVpcAuthorization].
 */
@PulumiTagMarker
public class UserVpcAuthorizationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserVpcAuthorizationArgs = UserVpcAuthorizationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserVpcAuthorizationArgsBuilder.() -> Unit) {
        val builder = UserVpcAuthorizationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserVpcAuthorization {
        val builtJavaResource = com.pulumi.alicloud.pvtz.UserVpcAuthorization(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserVpcAuthorization(builtJavaResource)
    }
}

/**
 * Provides a Private Zone User Vpc Authorization resource.
 * > **NOTE:** Available since v1.138.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const authorizedUserId = config.getNumber("authorizedUserId") || 123456789;
 * const example = new alicloud.pvtz.UserVpcAuthorization("example", {
 *     authorizedUserId: authorizedUserId,
 *     authChannel: "RESOURCE_DIRECTORY",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * authorized_user_id = config.get_float("authorizedUserId")
 * if authorized_user_id is None:
 *     authorized_user_id = 123456789
 * example = alicloud.pvtz.UserVpcAuthorization("example",
 *     authorized_user_id=authorized_user_id,
 *     auth_channel="RESOURCE_DIRECTORY")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var authorizedUserId = config.GetDouble("authorizedUserId") ?? 123456789;
 *     var example = new AliCloud.Pvtz.UserVpcAuthorization("example", new()
 *     {
 *         AuthorizedUserId = authorizedUserId,
 *         AuthChannel = "RESOURCE_DIRECTORY",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		authorizedUserId := float64(123456789)
 * 		if param := cfg.GetFloat64("authorizedUserId"); param != 0 {
 * 			authorizedUserId = param
 * 		}
 * 		_, err := pvtz.NewUserVpcAuthorization(ctx, "example", &pvtz.UserVpcAuthorizationArgs{
 * 			AuthorizedUserId: pulumi.Float64(authorizedUserId),
 * 			AuthChannel:      pulumi.String("RESOURCE_DIRECTORY"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.pvtz.UserVpcAuthorization;
 * import com.pulumi.alicloud.pvtz.UserVpcAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var authorizedUserId = config.get("authorizedUserId").orElse(123456789);
 *         var example = new UserVpcAuthorization("example", UserVpcAuthorizationArgs.builder()
 *             .authorizedUserId(authorizedUserId)
 *             .authChannel("RESOURCE_DIRECTORY")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   authorizedUserId:
 *     type: number
 *     default: 1.23456789e+08
 * resources:
 *   example:
 *     type: alicloud:pvtz:UserVpcAuthorization
 *     properties:
 *       authorizedUserId: ${authorizedUserId}
 *       authChannel: RESOURCE_DIRECTORY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Private Zone User Vpc Authorization can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:pvtz/userVpcAuthorization:UserVpcAuthorization example <authorized_user_id>:<auth_type>
 * ```
 */
public class UserVpcAuthorization internal constructor(
    override val javaResource: com.pulumi.alicloud.pvtz.UserVpcAuthorization,
) : KotlinCustomResource(javaResource, UserVpcAuthorizationMapper) {
    /**
     * The auth channel. Valid values: `RESOURCE_DIRECTORY`.
     */
    public val authChannel: Output<String>?
        get() = javaResource.authChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of Authorization. Valid values: `NORMAL` and `CLOUD_PRODUCT`.
     */
    public val authType: Output<String>?
        get() = javaResource.authType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The primary account ID of the user who authorizes the resource.
     */
    public val authorizedUserId: Output<String>
        get() = javaResource.authorizedUserId().applyValue({ args0 -> args0 })
}

public object UserVpcAuthorizationMapper : ResourceMapper<UserVpcAuthorization> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.pvtz.UserVpcAuthorization::class == javaResource::class

    override fun map(javaResource: Resource): UserVpcAuthorization = UserVpcAuthorization(
        javaResource
            as com.pulumi.alicloud.pvtz.UserVpcAuthorization,
    )
}

/**
 * @see [UserVpcAuthorization].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserVpcAuthorization].
 */
public suspend fun userVpcAuthorization(
    name: String,
    block: suspend UserVpcAuthorizationResourceBuilder.() -> Unit,
): UserVpcAuthorization {
    val builder = UserVpcAuthorizationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserVpcAuthorization].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userVpcAuthorization(name: String): UserVpcAuthorization {
    val builder = UserVpcAuthorizationResourceBuilder()
    builder.name(name)
    return builder.build()
}
