@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.alicloud.pvtz.UserVpcAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Private Zone User Vpc Authorization resource.
 * > **NOTE:** Available since v1.138.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const authorizedUserId = config.getNumber("authorizedUserId") || 123456789;
 * const example = new alicloud.pvtz.UserVpcAuthorization("example", {
 *     authorizedUserId: authorizedUserId,
 *     authChannel: "RESOURCE_DIRECTORY",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * authorized_user_id = config.get_float("authorizedUserId")
 * if authorized_user_id is None:
 *     authorized_user_id = 123456789
 * example = alicloud.pvtz.UserVpcAuthorization("example",
 *     authorized_user_id=authorized_user_id,
 *     auth_channel="RESOURCE_DIRECTORY")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var authorizedUserId = config.GetDouble("authorizedUserId") ?? 123456789;
 *     var example = new AliCloud.Pvtz.UserVpcAuthorization("example", new()
 *     {
 *         AuthorizedUserId = authorizedUserId,
 *         AuthChannel = "RESOURCE_DIRECTORY",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		authorizedUserId := float64(123456789)
 * 		if param := cfg.GetFloat64("authorizedUserId"); param != 0 {
 * 			authorizedUserId = param
 * 		}
 * 		_, err := pvtz.NewUserVpcAuthorization(ctx, "example", &pvtz.UserVpcAuthorizationArgs{
 * 			AuthorizedUserId: pulumi.Float64(authorizedUserId),
 * 			AuthChannel:      pulumi.String("RESOURCE_DIRECTORY"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.pvtz.UserVpcAuthorization;
 * import com.pulumi.alicloud.pvtz.UserVpcAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var authorizedUserId = config.get("authorizedUserId").orElse(123456789);
 *         var example = new UserVpcAuthorization("example", UserVpcAuthorizationArgs.builder()
 *             .authorizedUserId(authorizedUserId)
 *             .authChannel("RESOURCE_DIRECTORY")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   authorizedUserId:
 *     type: number
 *     default: 1.23456789e+08
 * resources:
 *   example:
 *     type: alicloud:pvtz:UserVpcAuthorization
 *     properties:
 *       authorizedUserId: ${authorizedUserId}
 *       authChannel: RESOURCE_DIRECTORY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Private Zone User Vpc Authorization can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:pvtz/userVpcAuthorization:UserVpcAuthorization example <authorized_user_id>:<auth_type>
 * ```
 * @property authChannel The auth channel. Valid values: `RESOURCE_DIRECTORY`.
 * @property authType The type of Authorization. Valid values: `NORMAL` and `CLOUD_PRODUCT`.
 * @property authorizedUserId The primary account ID of the user who authorizes the resource.
 */
public data class UserVpcAuthorizationArgs(
    public val authChannel: Output<String>? = null,
    public val authType: Output<String>? = null,
    public val authorizedUserId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.UserVpcAuthorizationArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.UserVpcAuthorizationArgs =
        com.pulumi.alicloud.pvtz.UserVpcAuthorizationArgs.builder()
            .authChannel(authChannel?.applyValue({ args0 -> args0 }))
            .authType(authType?.applyValue({ args0 -> args0 }))
            .authorizedUserId(authorizedUserId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserVpcAuthorizationArgs].
 */
@PulumiTagMarker
public class UserVpcAuthorizationArgsBuilder internal constructor() {
    private var authChannel: Output<String>? = null

    private var authType: Output<String>? = null

    private var authorizedUserId: Output<String>? = null

    /**
     * @param value The auth channel. Valid values: `RESOURCE_DIRECTORY`.
     */
    @JvmName("pbannlkpkyswhtnj")
    public suspend fun authChannel(`value`: Output<String>) {
        this.authChannel = value
    }

    /**
     * @param value The type of Authorization. Valid values: `NORMAL` and `CLOUD_PRODUCT`.
     */
    @JvmName("mtokuyulvrfyokhy")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value The primary account ID of the user who authorizes the resource.
     */
    @JvmName("fwcclathsiqdufuq")
    public suspend fun authorizedUserId(`value`: Output<String>) {
        this.authorizedUserId = value
    }

    /**
     * @param value The auth channel. Valid values: `RESOURCE_DIRECTORY`.
     */
    @JvmName("qiknmbcsmspjmgnk")
    public suspend fun authChannel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authChannel = mapped
    }

    /**
     * @param value The type of Authorization. Valid values: `NORMAL` and `CLOUD_PRODUCT`.
     */
    @JvmName("chempqyercydgubs")
    public suspend fun authType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value The primary account ID of the user who authorizes the resource.
     */
    @JvmName("lyyfavatcmtoulnm")
    public suspend fun authorizedUserId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizedUserId = mapped
    }

    internal fun build(): UserVpcAuthorizationArgs = UserVpcAuthorizationArgs(
        authChannel = authChannel,
        authType = authType,
        authorizedUserId = authorizedUserId,
    )
}
