@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.alicloud.pvtz.kotlin.outputs.ZoneUserInfo
import com.pulumi.alicloud.pvtz.kotlin.outputs.ZoneUserInfo.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Zone].
 */
@PulumiTagMarker
public class ZoneResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ZoneArgs = ZoneArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ZoneArgsBuilder.() -> Unit) {
        val builder = ZoneArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Zone {
        val builtJavaResource = com.pulumi.alicloud.pvtz.Zone(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Zone(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = new alicloud.pvtz.Zone("foo", {zoneName: "foo.example.com"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.pvtz.Zone("foo", zone_name="foo.example.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new AliCloud.Pvtz.Zone("foo", new()
 *     {
 *         ZoneName = "foo.example.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := pvtz.NewZone(ctx, "foo", &pvtz.ZoneArgs{
 * 			ZoneName: pulumi.String("foo.example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.pvtz.Zone;
 * import com.pulumi.alicloud.pvtz.ZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Zone("foo", ZoneArgs.builder()
 *             .zoneName("foo.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: alicloud:pvtz:Zone
 *     properties:
 *       zoneName: foo.example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Private Zone can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:pvtz/zone:Zone example abc123456
 * ```
 */
public class Zone internal constructor(
    override val javaResource: com.pulumi.alicloud.pvtz.Zone,
) : KotlinCustomResource(javaResource, ZoneMapper) {
    /**
     * Whether the Private Zone is ptr.
     */
    public val isPtr: Output<Boolean>
        get() = javaResource.isPtr().applyValue({ args0 -> args0 })

    /**
     * The language. Valid values: "zh", "en", "jp".
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the Private Zone. The `name` has been deprecated from provider version 1.107.0. Please use 'zone_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.107.0. Use 'zone_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The recursive DNS proxy. Valid values:
     * - ZONE: indicates that the recursive DNS proxy is disabled.
     * - RECORD: indicates that the recursive DNS proxy is enabled.
     * Default to "ZONE".
     */
    public val proxyPattern: Output<String>?
        get() = javaResource.proxyPattern().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The count of the Private Zone Record.
     */
    public val recordCount: Output<Int>
        get() = javaResource.recordCount().applyValue({ args0 -> args0 })

    /**
     * The remark of the Private Zone.
     */
    public val remark: Output<String>?
        get() = javaResource.remark().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Id of resource group which the Private Zone belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the host synchronization task. Valid values:  `ON`,`OFF`. **NOTE:** You can update the `sync_status` to enable/disable the host synchronization task.
     */
    public val syncStatus: Output<String>?
        get() = javaResource.syncStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The tags of the Private Zone.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The IP address of the client.
     */
    public val userClientIp: Output<String>?
        get() = javaResource.userClientIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The user information of the host synchronization task. See `user_info` below.
     */
    public val userInfos: Output<List<ZoneUserInfo>>
        get() = javaResource.userInfos().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The zone_name of the Private Zone. The `zone_name` is required when the value of the `name`  is Empty.
     */
    public val zoneName: Output<String>
        get() = javaResource.zoneName().applyValue({ args0 -> args0 })
}

public object ZoneMapper : ResourceMapper<Zone> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.pvtz.Zone::class == javaResource::class

    override fun map(javaResource: Resource): Zone = Zone(
        javaResource as
            com.pulumi.alicloud.pvtz.Zone,
    )
}

/**
 * @see [Zone].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Zone].
 */
public suspend fun zone(name: String, block: suspend ZoneResourceBuilder.() -> Unit): Zone {
    val builder = ZoneResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Zone].
 * @param name The _unique_ name of the resulting resource.
 */
public fun zone(name: String): Zone {
    val builder = ZoneResourceBuilder()
    builder.name(name)
    return builder.build()
}
