@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.alicloud.pvtz.ZoneArgs.builder
import com.pulumi.alicloud.pvtz.kotlin.inputs.ZoneUserInfoArgs
import com.pulumi.alicloud.pvtz.kotlin.inputs.ZoneUserInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const foo = new alicloud.pvtz.Zone("foo", {zoneName: "foo.example.com"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * foo = alicloud.pvtz.Zone("foo", zone_name="foo.example.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new AliCloud.Pvtz.Zone("foo", new()
 *     {
 *         ZoneName = "foo.example.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := pvtz.NewZone(ctx, "foo", &pvtz.ZoneArgs{
 * 			ZoneName: pulumi.String("foo.example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.pvtz.Zone;
 * import com.pulumi.alicloud.pvtz.ZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Zone("foo", ZoneArgs.builder()
 *             .zoneName("foo.example.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: alicloud:pvtz:Zone
 *     properties:
 *       zoneName: foo.example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Private Zone can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:pvtz/zone:Zone example abc123456
 * ```
 * @property lang The language. Valid values: "zh", "en", "jp".
 * @property name The name of the Private Zone. The `name` has been deprecated from provider version 1.107.0. Please use 'zone_name' instead.
 * @property proxyPattern The recursive DNS proxy. Valid values:
 * - ZONE: indicates that the recursive DNS proxy is disabled.
 * - RECORD: indicates that the recursive DNS proxy is enabled.
 * Default to "ZONE".
 * @property remark The remark of the Private Zone.
 * @property resourceGroupId The Id of resource group which the Private Zone belongs.
 * @property syncStatus The status of the host synchronization task. Valid values:  `ON`,`OFF`. **NOTE:** You can update the `sync_status` to enable/disable the host synchronization task.
 * @property tags The tags of the Private Zone.
 * @property userClientIp The IP address of the client.
 * @property userInfos The user information of the host synchronization task. See `user_info` below.
 * @property zoneName The zone_name of the Private Zone. The `zone_name` is required when the value of the `name`  is Empty.
 */
public data class ZoneArgs(
    public val lang: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.107.0. Use 'zone_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val proxyPattern: Output<String>? = null,
    public val remark: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val syncStatus: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userClientIp: Output<String>? = null,
    public val userInfos: Output<List<ZoneUserInfoArgs>>? = null,
    public val zoneName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.ZoneArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.ZoneArgs =
        com.pulumi.alicloud.pvtz.ZoneArgs.builder()
            .lang(lang?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .proxyPattern(proxyPattern?.applyValue({ args0 -> args0 }))
            .remark(remark?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .syncStatus(syncStatus?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userClientIp(userClientIp?.applyValue({ args0 -> args0 }))
            .userInfos(
                userInfos?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .zoneName(zoneName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ZoneArgs].
 */
@PulumiTagMarker
public class ZoneArgsBuilder internal constructor() {
    private var lang: Output<String>? = null

    private var name: Output<String>? = null

    private var proxyPattern: Output<String>? = null

    private var remark: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var syncStatus: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userClientIp: Output<String>? = null

    private var userInfos: Output<List<ZoneUserInfoArgs>>? = null

    private var zoneName: Output<String>? = null

    /**
     * @param value The language. Valid values: "zh", "en", "jp".
     */
    @JvmName("rmhfsneyxjtocokk")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The name of the Private Zone. The `name` has been deprecated from provider version 1.107.0. Please use 'zone_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.107.0. Use 'zone_name' instead.
  """,
    )
    @JvmName("tidjsfpceeutosch")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The recursive DNS proxy. Valid values:
     * - ZONE: indicates that the recursive DNS proxy is disabled.
     * - RECORD: indicates that the recursive DNS proxy is enabled.
     * Default to "ZONE".
     */
    @JvmName("ckwivtunoialnlln")
    public suspend fun proxyPattern(`value`: Output<String>) {
        this.proxyPattern = value
    }

    /**
     * @param value The remark of the Private Zone.
     */
    @JvmName("dmsrenuxvsgeobyo")
    public suspend fun remark(`value`: Output<String>) {
        this.remark = value
    }

    /**
     * @param value The Id of resource group which the Private Zone belongs.
     */
    @JvmName("wnvfvdkruhdmdfkl")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The status of the host synchronization task. Valid values:  `ON`,`OFF`. **NOTE:** You can update the `sync_status` to enable/disable the host synchronization task.
     */
    @JvmName("weapbpugwasiufqc")
    public suspend fun syncStatus(`value`: Output<String>) {
        this.syncStatus = value
    }

    /**
     * @param value The tags of the Private Zone.
     */
    @JvmName("stxvhtscbextygsq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The IP address of the client.
     */
    @JvmName("lkajbvfbftncumps")
    public suspend fun userClientIp(`value`: Output<String>) {
        this.userClientIp = value
    }

    /**
     * @param value The user information of the host synchronization task. See `user_info` below.
     */
    @JvmName("npadjosyywuydldv")
    public suspend fun userInfos(`value`: Output<List<ZoneUserInfoArgs>>) {
        this.userInfos = value
    }

    @JvmName("kqbdbwqgrudquhgw")
    public suspend fun userInfos(vararg values: Output<ZoneUserInfoArgs>) {
        this.userInfos = Output.all(values.asList())
    }

    /**
     * @param values The user information of the host synchronization task. See `user_info` below.
     */
    @JvmName("hdobpdrbticatjsn")
    public suspend fun userInfos(values: List<Output<ZoneUserInfoArgs>>) {
        this.userInfos = Output.all(values)
    }

    /**
     * @param value The zone_name of the Private Zone. The `zone_name` is required when the value of the `name`  is Empty.
     */
    @JvmName("yjyhntpvbvbuqaac")
    public suspend fun zoneName(`value`: Output<String>) {
        this.zoneName = value
    }

    /**
     * @param value The language. Valid values: "zh", "en", "jp".
     */
    @JvmName("jwvlfnwsgydycavu")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The name of the Private Zone. The `name` has been deprecated from provider version 1.107.0. Please use 'zone_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from version 1.107.0. Use 'zone_name' instead.
  """,
    )
    @JvmName("lgbtjawalitqwlne")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The recursive DNS proxy. Valid values:
     * - ZONE: indicates that the recursive DNS proxy is disabled.
     * - RECORD: indicates that the recursive DNS proxy is enabled.
     * Default to "ZONE".
     */
    @JvmName("vpvogonnuyuxvpth")
    public suspend fun proxyPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyPattern = mapped
    }

    /**
     * @param value The remark of the Private Zone.
     */
    @JvmName("quawnbnqvhwtvhth")
    public suspend fun remark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remark = mapped
    }

    /**
     * @param value The Id of resource group which the Private Zone belongs.
     */
    @JvmName("qrbpprwrqrtvjkqb")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The status of the host synchronization task. Valid values:  `ON`,`OFF`. **NOTE:** You can update the `sync_status` to enable/disable the host synchronization task.
     */
    @JvmName("vetgoalioudjcvvq")
    public suspend fun syncStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncStatus = mapped
    }

    /**
     * @param value The tags of the Private Zone.
     */
    @JvmName("lhcbiurnqbaiqkay")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the Private Zone.
     */
    @JvmName("mckuybcysyfwqjhx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The IP address of the client.
     */
    @JvmName("basphohebkkbnjqc")
    public suspend fun userClientIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userClientIp = mapped
    }

    /**
     * @param value The user information of the host synchronization task. See `user_info` below.
     */
    @JvmName("veikhpitebmbmlui")
    public suspend fun userInfos(`value`: List<ZoneUserInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userInfos = mapped
    }

    /**
     * @param argument The user information of the host synchronization task. See `user_info` below.
     */
    @JvmName("yjggwykeeuxttyrp")
    public suspend fun userInfos(argument: List<suspend ZoneUserInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ZoneUserInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userInfos = mapped
    }

    /**
     * @param argument The user information of the host synchronization task. See `user_info` below.
     */
    @JvmName("kxglgjovtuxvsxiv")
    public suspend fun userInfos(vararg argument: suspend ZoneUserInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ZoneUserInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userInfos = mapped
    }

    /**
     * @param argument The user information of the host synchronization task. See `user_info` below.
     */
    @JvmName("thvexvjcacavkdqx")
    public suspend fun userInfos(argument: suspend ZoneUserInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ZoneUserInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userInfos = mapped
    }

    /**
     * @param values The user information of the host synchronization task. See `user_info` below.
     */
    @JvmName("odobpdtccxmapiof")
    public suspend fun userInfos(vararg values: ZoneUserInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userInfos = mapped
    }

    /**
     * @param value The zone_name of the Private Zone. The `zone_name` is required when the value of the `name`  is Empty.
     */
    @JvmName("lovfnbapcqebctyu")
    public suspend fun zoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneName = mapped
    }

    internal fun build(): ZoneArgs = ZoneArgs(
        lang = lang,
        name = name,
        proxyPattern = proxyPattern,
        remark = remark,
        resourceGroupId = resourceGroupId,
        syncStatus = syncStatus,
        tags = tags,
        userClientIp = userClientIp,
        userInfos = userInfos,
        zoneName = zoneName,
    )
}
