@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.alicloud.pvtz.kotlin.outputs.ZoneAttachmentVpc
import com.pulumi.alicloud.pvtz.kotlin.outputs.ZoneAttachmentVpc.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ZoneAttachment].
 */
@PulumiTagMarker
public class ZoneAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ZoneAttachmentArgs = ZoneAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ZoneAttachmentArgsBuilder.() -> Unit) {
        val builder = ZoneAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ZoneAttachment {
        val builtJavaResource = com.pulumi.alicloud.pvtz.ZoneAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ZoneAttachment(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Using `vpc_ids` to attach being in same region several vpc instances to a private zone
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const zone = new alicloud.pvtz.Zone("zone", {zoneName: "foo.example.com"});
 * const first = new alicloud.vpc.Network("first", {
 *     vpcName: "the-first-vpc",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const second = new alicloud.vpc.Network("second", {
 *     vpcName: "the-second-vpc",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const zone_attachment = new alicloud.pvtz.ZoneAttachment("zone-attachment", {
 *     zoneId: zone.id,
 *     vpcIds: [
 *         first.id,
 *         second.id,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * zone = alicloud.pvtz.Zone("zone", zone_name="foo.example.com")
 * first = alicloud.vpc.Network("first",
 *     vpc_name="the-first-vpc",
 *     cidr_block="172.16.0.0/12")
 * second = alicloud.vpc.Network("second",
 *     vpc_name="the-second-vpc",
 *     cidr_block="172.16.0.0/16")
 * zone_attachment = alicloud.pvtz.ZoneAttachment("zone-attachment",
 *     zone_id=zone.id,
 *     vpc_ids=[
 *         first.id,
 *         second.id,
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var zone = new AliCloud.Pvtz.Zone("zone", new()
 *     {
 *         ZoneName = "foo.example.com",
 *     });
 *     var first = new AliCloud.Vpc.Network("first", new()
 *     {
 *         VpcName = "the-first-vpc",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var second = new AliCloud.Vpc.Network("second", new()
 *     {
 *         VpcName = "the-second-vpc",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var zone_attachment = new AliCloud.Pvtz.ZoneAttachment("zone-attachment", new()
 *     {
 *         ZoneId = zone.Id,
 *         VpcIds = new[]
 *         {
 *             first.Id,
 *             second.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		zone, err := pvtz.NewZone(ctx, "zone", &pvtz.ZoneArgs{
 * 			ZoneName: pulumi.String("foo.example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		first, err := vpc.NewNetwork(ctx, "first", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-first-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		second, err := vpc.NewNetwork(ctx, "second", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-second-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pvtz.NewZoneAttachment(ctx, "zone-attachment", &pvtz.ZoneAttachmentArgs{
 * 			ZoneId: zone.ID(),
 * 			VpcIds: pulumi.StringArray{
 * 				first.ID(),
 * 				second.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.pvtz.Zone;
 * import com.pulumi.alicloud.pvtz.ZoneArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.pvtz.ZoneAttachment;
 * import com.pulumi.alicloud.pvtz.ZoneAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var zone = new Zone("zone", ZoneArgs.builder()
 *             .zoneName("foo.example.com")
 *             .build());
 *         var first = new Network("first", NetworkArgs.builder()
 *             .vpcName("the-first-vpc")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var second = new Network("second", NetworkArgs.builder()
 *             .vpcName("the-second-vpc")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var zone_attachment = new ZoneAttachment("zone-attachment", ZoneAttachmentArgs.builder()
 *             .zoneId(zone.id())
 *             .vpcIds(
 *                 first.id(),
 *                 second.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   zone:
 *     type: alicloud:pvtz:Zone
 *     properties:
 *       zoneName: foo.example.com
 *   first:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-first-vpc
 *       cidrBlock: 172.16.0.0/12
 *   second:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-second-vpc
 *       cidrBlock: 172.16.0.0/16
 *   zone-attachment:
 *     type: alicloud:pvtz:ZoneAttachment
 *     properties:
 *       zoneId: ${zone.id}
 *       vpcIds:
 *         - ${first.id}
 *         - ${second.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * Using `vpcs` to attach being in same region several vpc instances to a private zone
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const zone = new alicloud.pvtz.Zone("zone", {zoneName: "foo.example.com"});
 * const first = new alicloud.vpc.Network("first", {
 *     vpcName: "the-first-vpc",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const second = new alicloud.vpc.Network("second", {
 *     vpcName: "the-second-vpc",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const zone_attachment = new alicloud.pvtz.ZoneAttachment("zone-attachment", {
 *     zoneId: zone.id,
 *     vpcs: [
 *         {
 *             vpcId: first.id,
 *         },
 *         {
 *             vpcId: second.id,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * zone = alicloud.pvtz.Zone("zone", zone_name="foo.example.com")
 * first = alicloud.vpc.Network("first",
 *     vpc_name="the-first-vpc",
 *     cidr_block="172.16.0.0/12")
 * second = alicloud.vpc.Network("second",
 *     vpc_name="the-second-vpc",
 *     cidr_block="172.16.0.0/16")
 * zone_attachment = alicloud.pvtz.ZoneAttachment("zone-attachment",
 *     zone_id=zone.id,
 *     vpcs=[
 *         {
 *             "vpc_id": first.id,
 *         },
 *         {
 *             "vpc_id": second.id,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var zone = new AliCloud.Pvtz.Zone("zone", new()
 *     {
 *         ZoneName = "foo.example.com",
 *     });
 *     var first = new AliCloud.Vpc.Network("first", new()
 *     {
 *         VpcName = "the-first-vpc",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var second = new AliCloud.Vpc.Network("second", new()
 *     {
 *         VpcName = "the-second-vpc",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var zone_attachment = new AliCloud.Pvtz.ZoneAttachment("zone-attachment", new()
 *     {
 *         ZoneId = zone.Id,
 *         Vpcs = new[]
 *         {
 *             new AliCloud.Pvtz.Inputs.ZoneAttachmentVpcArgs
 *             {
 *                 VpcId = first.Id,
 *             },
 *             new AliCloud.Pvtz.Inputs.ZoneAttachmentVpcArgs
 *             {
 *                 VpcId = second.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		zone, err := pvtz.NewZone(ctx, "zone", &pvtz.ZoneArgs{
 * 			ZoneName: pulumi.String("foo.example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		first, err := vpc.NewNetwork(ctx, "first", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-first-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		second, err := vpc.NewNetwork(ctx, "second", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-second-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pvtz.NewZoneAttachment(ctx, "zone-attachment", &pvtz.ZoneAttachmentArgs{
 * 			ZoneId: zone.ID(),
 * 			Vpcs: pvtz.ZoneAttachmentVpcArray{
 * 				&pvtz.ZoneAttachmentVpcArgs{
 * 					VpcId: first.ID(),
 * 				},
 * 				&pvtz.ZoneAttachmentVpcArgs{
 * 					VpcId: second.ID(),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.pvtz.Zone;
 * import com.pulumi.alicloud.pvtz.ZoneArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.pvtz.ZoneAttachment;
 * import com.pulumi.alicloud.pvtz.ZoneAttachmentArgs;
 * import com.pulumi.alicloud.pvtz.inputs.ZoneAttachmentVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var zone = new Zone("zone", ZoneArgs.builder()
 *             .zoneName("foo.example.com")
 *             .build());
 *         var first = new Network("first", NetworkArgs.builder()
 *             .vpcName("the-first-vpc")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var second = new Network("second", NetworkArgs.builder()
 *             .vpcName("the-second-vpc")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var zone_attachment = new ZoneAttachment("zone-attachment", ZoneAttachmentArgs.builder()
 *             .zoneId(zone.id())
 *             .vpcs(
 *                 ZoneAttachmentVpcArgs.builder()
 *                     .vpcId(first.id())
 *                     .build(),
 *                 ZoneAttachmentVpcArgs.builder()
 *                     .vpcId(second.id())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   zone:
 *     type: alicloud:pvtz:Zone
 *     properties:
 *       zoneName: foo.example.com
 *   first:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-first-vpc
 *       cidrBlock: 172.16.0.0/12
 *   second:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-second-vpc
 *       cidrBlock: 172.16.0.0/16
 *   zone-attachment:
 *     type: alicloud:pvtz:ZoneAttachment
 *     properties:
 *       zoneId: ${zone.id}
 *       vpcs:
 *         - vpcId: ${first.id}
 *         - vpcId: ${second.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * Using `vpcs` to attach being in different regions several vpc instances to a private zone
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const zone = new alicloud.pvtz.Zone("zone", {zoneName: "foo.example.com"});
 * const first = new alicloud.vpc.Network("first", {
 *     vpcName: "the-first-vpc",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const second = new alicloud.vpc.Network("second", {
 *     vpcName: "the-second-vpc",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const third = new alicloud.vpc.Network("third", {
 *     vpcName: "the-third-vpc",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const zone_attachment = new alicloud.pvtz.ZoneAttachment("zone-attachment", {
 *     zoneId: zone.id,
 *     vpcs: [
 *         {
 *             vpcId: first.id,
 *         },
 *         {
 *             vpcId: second.id,
 *         },
 *         {
 *             regionId: "eu-central-1",
 *             vpcId: third.id,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * zone = alicloud.pvtz.Zone("zone", zone_name="foo.example.com")
 * first = alicloud.vpc.Network("first",
 *     vpc_name="the-first-vpc",
 *     cidr_block="172.16.0.0/12")
 * second = alicloud.vpc.Network("second",
 *     vpc_name="the-second-vpc",
 *     cidr_block="172.16.0.0/16")
 * third = alicloud.vpc.Network("third",
 *     vpc_name="the-third-vpc",
 *     cidr_block="172.16.0.0/16")
 * zone_attachment = alicloud.pvtz.ZoneAttachment("zone-attachment",
 *     zone_id=zone.id,
 *     vpcs=[
 *         {
 *             "vpc_id": first.id,
 *         },
 *         {
 *             "vpc_id": second.id,
 *         },
 *         {
 *             "region_id": "eu-central-1",
 *             "vpc_id": third.id,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var zone = new AliCloud.Pvtz.Zone("zone", new()
 *     {
 *         ZoneName = "foo.example.com",
 *     });
 *     var first = new AliCloud.Vpc.Network("first", new()
 *     {
 *         VpcName = "the-first-vpc",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var second = new AliCloud.Vpc.Network("second", new()
 *     {
 *         VpcName = "the-second-vpc",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var third = new AliCloud.Vpc.Network("third", new()
 *     {
 *         VpcName = "the-third-vpc",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var zone_attachment = new AliCloud.Pvtz.ZoneAttachment("zone-attachment", new()
 *     {
 *         ZoneId = zone.Id,
 *         Vpcs = new[]
 *         {
 *             new AliCloud.Pvtz.Inputs.ZoneAttachmentVpcArgs
 *             {
 *                 VpcId = first.Id,
 *             },
 *             new AliCloud.Pvtz.Inputs.ZoneAttachmentVpcArgs
 *             {
 *                 VpcId = second.Id,
 *             },
 *             new AliCloud.Pvtz.Inputs.ZoneAttachmentVpcArgs
 *             {
 *                 RegionId = "eu-central-1",
 *                 VpcId = third.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		zone, err := pvtz.NewZone(ctx, "zone", &pvtz.ZoneArgs{
 * 			ZoneName: pulumi.String("foo.example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		first, err := vpc.NewNetwork(ctx, "first", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-first-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		second, err := vpc.NewNetwork(ctx, "second", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-second-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		third, err := vpc.NewNetwork(ctx, "third", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-third-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pvtz.NewZoneAttachment(ctx, "zone-attachment", &pvtz.ZoneAttachmentArgs{
 * 			ZoneId: zone.ID(),
 * 			Vpcs: pvtz.ZoneAttachmentVpcArray{
 * 				&pvtz.ZoneAttachmentVpcArgs{
 * 					VpcId: first.ID(),
 * 				},
 * 				&pvtz.ZoneAttachmentVpcArgs{
 * 					VpcId: second.ID(),
 * 				},
 * 				&pvtz.ZoneAttachmentVpcArgs{
 * 					RegionId: pulumi.String("eu-central-1"),
 * 					VpcId:    third.ID(),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.pvtz.Zone;
 * import com.pulumi.alicloud.pvtz.ZoneArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.pvtz.ZoneAttachment;
 * import com.pulumi.alicloud.pvtz.ZoneAttachmentArgs;
 * import com.pulumi.alicloud.pvtz.inputs.ZoneAttachmentVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var zone = new Zone("zone", ZoneArgs.builder()
 *             .zoneName("foo.example.com")
 *             .build());
 *         var first = new Network("first", NetworkArgs.builder()
 *             .vpcName("the-first-vpc")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var second = new Network("second", NetworkArgs.builder()
 *             .vpcName("the-second-vpc")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var third = new Network("third", NetworkArgs.builder()
 *             .vpcName("the-third-vpc")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var zone_attachment = new ZoneAttachment("zone-attachment", ZoneAttachmentArgs.builder()
 *             .zoneId(zone.id())
 *             .vpcs(
 *                 ZoneAttachmentVpcArgs.builder()
 *                     .vpcId(first.id())
 *                     .build(),
 *                 ZoneAttachmentVpcArgs.builder()
 *                     .vpcId(second.id())
 *                     .build(),
 *                 ZoneAttachmentVpcArgs.builder()
 *                     .regionId("eu-central-1")
 *                     .vpcId(third.id())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   zone:
 *     type: alicloud:pvtz:Zone
 *     properties:
 *       zoneName: foo.example.com
 *   first:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-first-vpc
 *       cidrBlock: 172.16.0.0/12
 *   second:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-second-vpc
 *       cidrBlock: 172.16.0.0/16
 *   third:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-third-vpc
 *       cidrBlock: 172.16.0.0/16
 *   zone-attachment:
 *     type: alicloud:pvtz:ZoneAttachment
 *     properties:
 *       zoneId: ${zone.id}
 *       vpcs:
 *         - vpcId: ${first.id}
 *         - vpcId: ${second.id}
 *         - regionId: eu-central-1
 *           vpcId: ${third.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Private Zone attachment can be imported using the id(same with `zone_id`), e.g.
 * ```sh
 * $ pulumi import alicloud:pvtz/zoneAttachment:ZoneAttachment example abc123456
 * ```
 */
public class ZoneAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.pvtz.ZoneAttachment,
) : KotlinCustomResource(javaResource, ZoneAttachmentMapper) {
    /**
     * The language of code.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The user custom IP address.
     */
    public val userClientIp: Output<String>?
        get() = javaResource.userClientIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id List of the VPC with the same region, for example:["vpc-1","vpc-2"].
     */
    public val vpcIds: Output<List<String>>
        get() = javaResource.vpcIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * See `vpcs` below.Recommend to use `vpcs`.
     */
    public val vpcs: Output<List<ZoneAttachmentVpc>>
        get() = javaResource.vpcs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The name of the Private Zone Record.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object ZoneAttachmentMapper : ResourceMapper<ZoneAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.pvtz.ZoneAttachment::class == javaResource::class

    override fun map(javaResource: Resource): ZoneAttachment = ZoneAttachment(
        javaResource as
            com.pulumi.alicloud.pvtz.ZoneAttachment,
    )
}

/**
 * @see [ZoneAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ZoneAttachment].
 */
public suspend fun zoneAttachment(
    name: String,
    block: suspend ZoneAttachmentResourceBuilder.() -> Unit,
): ZoneAttachment {
    val builder = ZoneAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ZoneAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun zoneAttachment(name: String): ZoneAttachment {
    val builder = ZoneAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
