@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.alicloud.pvtz.ZoneAttachmentArgs.builder
import com.pulumi.alicloud.pvtz.kotlin.inputs.ZoneAttachmentVpcArgs
import com.pulumi.alicloud.pvtz.kotlin.inputs.ZoneAttachmentVpcArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Using `vpc_ids` to attach being in same region several vpc instances to a private zone
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const zone = new alicloud.pvtz.Zone("zone", {zoneName: "foo.example.com"});
 * const first = new alicloud.vpc.Network("first", {
 *     vpcName: "the-first-vpc",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const second = new alicloud.vpc.Network("second", {
 *     vpcName: "the-second-vpc",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const zone_attachment = new alicloud.pvtz.ZoneAttachment("zone-attachment", {
 *     zoneId: zone.id,
 *     vpcIds: [
 *         first.id,
 *         second.id,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * zone = alicloud.pvtz.Zone("zone", zone_name="foo.example.com")
 * first = alicloud.vpc.Network("first",
 *     vpc_name="the-first-vpc",
 *     cidr_block="172.16.0.0/12")
 * second = alicloud.vpc.Network("second",
 *     vpc_name="the-second-vpc",
 *     cidr_block="172.16.0.0/16")
 * zone_attachment = alicloud.pvtz.ZoneAttachment("zone-attachment",
 *     zone_id=zone.id,
 *     vpc_ids=[
 *         first.id,
 *         second.id,
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var zone = new AliCloud.Pvtz.Zone("zone", new()
 *     {
 *         ZoneName = "foo.example.com",
 *     });
 *     var first = new AliCloud.Vpc.Network("first", new()
 *     {
 *         VpcName = "the-first-vpc",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var second = new AliCloud.Vpc.Network("second", new()
 *     {
 *         VpcName = "the-second-vpc",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var zone_attachment = new AliCloud.Pvtz.ZoneAttachment("zone-attachment", new()
 *     {
 *         ZoneId = zone.Id,
 *         VpcIds = new[]
 *         {
 *             first.Id,
 *             second.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		zone, err := pvtz.NewZone(ctx, "zone", &pvtz.ZoneArgs{
 * 			ZoneName: pulumi.String("foo.example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		first, err := vpc.NewNetwork(ctx, "first", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-first-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		second, err := vpc.NewNetwork(ctx, "second", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-second-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pvtz.NewZoneAttachment(ctx, "zone-attachment", &pvtz.ZoneAttachmentArgs{
 * 			ZoneId: zone.ID(),
 * 			VpcIds: pulumi.StringArray{
 * 				first.ID(),
 * 				second.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.pvtz.Zone;
 * import com.pulumi.alicloud.pvtz.ZoneArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.pvtz.ZoneAttachment;
 * import com.pulumi.alicloud.pvtz.ZoneAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var zone = new Zone("zone", ZoneArgs.builder()
 *             .zoneName("foo.example.com")
 *             .build());
 *         var first = new Network("first", NetworkArgs.builder()
 *             .vpcName("the-first-vpc")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var second = new Network("second", NetworkArgs.builder()
 *             .vpcName("the-second-vpc")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var zone_attachment = new ZoneAttachment("zone-attachment", ZoneAttachmentArgs.builder()
 *             .zoneId(zone.id())
 *             .vpcIds(
 *                 first.id(),
 *                 second.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   zone:
 *     type: alicloud:pvtz:Zone
 *     properties:
 *       zoneName: foo.example.com
 *   first:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-first-vpc
 *       cidrBlock: 172.16.0.0/12
 *   second:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-second-vpc
 *       cidrBlock: 172.16.0.0/16
 *   zone-attachment:
 *     type: alicloud:pvtz:ZoneAttachment
 *     properties:
 *       zoneId: ${zone.id}
 *       vpcIds:
 *         - ${first.id}
 *         - ${second.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * Using `vpcs` to attach being in same region several vpc instances to a private zone
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const zone = new alicloud.pvtz.Zone("zone", {zoneName: "foo.example.com"});
 * const first = new alicloud.vpc.Network("first", {
 *     vpcName: "the-first-vpc",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const second = new alicloud.vpc.Network("second", {
 *     vpcName: "the-second-vpc",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const zone_attachment = new alicloud.pvtz.ZoneAttachment("zone-attachment", {
 *     zoneId: zone.id,
 *     vpcs: [
 *         {
 *             vpcId: first.id,
 *         },
 *         {
 *             vpcId: second.id,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * zone = alicloud.pvtz.Zone("zone", zone_name="foo.example.com")
 * first = alicloud.vpc.Network("first",
 *     vpc_name="the-first-vpc",
 *     cidr_block="172.16.0.0/12")
 * second = alicloud.vpc.Network("second",
 *     vpc_name="the-second-vpc",
 *     cidr_block="172.16.0.0/16")
 * zone_attachment = alicloud.pvtz.ZoneAttachment("zone-attachment",
 *     zone_id=zone.id,
 *     vpcs=[
 *         {
 *             "vpc_id": first.id,
 *         },
 *         {
 *             "vpc_id": second.id,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var zone = new AliCloud.Pvtz.Zone("zone", new()
 *     {
 *         ZoneName = "foo.example.com",
 *     });
 *     var first = new AliCloud.Vpc.Network("first", new()
 *     {
 *         VpcName = "the-first-vpc",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var second = new AliCloud.Vpc.Network("second", new()
 *     {
 *         VpcName = "the-second-vpc",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var zone_attachment = new AliCloud.Pvtz.ZoneAttachment("zone-attachment", new()
 *     {
 *         ZoneId = zone.Id,
 *         Vpcs = new[]
 *         {
 *             new AliCloud.Pvtz.Inputs.ZoneAttachmentVpcArgs
 *             {
 *                 VpcId = first.Id,
 *             },
 *             new AliCloud.Pvtz.Inputs.ZoneAttachmentVpcArgs
 *             {
 *                 VpcId = second.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		zone, err := pvtz.NewZone(ctx, "zone", &pvtz.ZoneArgs{
 * 			ZoneName: pulumi.String("foo.example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		first, err := vpc.NewNetwork(ctx, "first", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-first-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		second, err := vpc.NewNetwork(ctx, "second", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-second-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pvtz.NewZoneAttachment(ctx, "zone-attachment", &pvtz.ZoneAttachmentArgs{
 * 			ZoneId: zone.ID(),
 * 			Vpcs: pvtz.ZoneAttachmentVpcArray{
 * 				&pvtz.ZoneAttachmentVpcArgs{
 * 					VpcId: first.ID(),
 * 				},
 * 				&pvtz.ZoneAttachmentVpcArgs{
 * 					VpcId: second.ID(),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.pvtz.Zone;
 * import com.pulumi.alicloud.pvtz.ZoneArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.pvtz.ZoneAttachment;
 * import com.pulumi.alicloud.pvtz.ZoneAttachmentArgs;
 * import com.pulumi.alicloud.pvtz.inputs.ZoneAttachmentVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var zone = new Zone("zone", ZoneArgs.builder()
 *             .zoneName("foo.example.com")
 *             .build());
 *         var first = new Network("first", NetworkArgs.builder()
 *             .vpcName("the-first-vpc")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var second = new Network("second", NetworkArgs.builder()
 *             .vpcName("the-second-vpc")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var zone_attachment = new ZoneAttachment("zone-attachment", ZoneAttachmentArgs.builder()
 *             .zoneId(zone.id())
 *             .vpcs(
 *                 ZoneAttachmentVpcArgs.builder()
 *                     .vpcId(first.id())
 *                     .build(),
 *                 ZoneAttachmentVpcArgs.builder()
 *                     .vpcId(second.id())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   zone:
 *     type: alicloud:pvtz:Zone
 *     properties:
 *       zoneName: foo.example.com
 *   first:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-first-vpc
 *       cidrBlock: 172.16.0.0/12
 *   second:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-second-vpc
 *       cidrBlock: 172.16.0.0/16
 *   zone-attachment:
 *     type: alicloud:pvtz:ZoneAttachment
 *     properties:
 *       zoneId: ${zone.id}
 *       vpcs:
 *         - vpcId: ${first.id}
 *         - vpcId: ${second.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * Using `vpcs` to attach being in different regions several vpc instances to a private zone
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const zone = new alicloud.pvtz.Zone("zone", {zoneName: "foo.example.com"});
 * const first = new alicloud.vpc.Network("first", {
 *     vpcName: "the-first-vpc",
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const second = new alicloud.vpc.Network("second", {
 *     vpcName: "the-second-vpc",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const third = new alicloud.vpc.Network("third", {
 *     vpcName: "the-third-vpc",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const zone_attachment = new alicloud.pvtz.ZoneAttachment("zone-attachment", {
 *     zoneId: zone.id,
 *     vpcs: [
 *         {
 *             vpcId: first.id,
 *         },
 *         {
 *             vpcId: second.id,
 *         },
 *         {
 *             regionId: "eu-central-1",
 *             vpcId: third.id,
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * zone = alicloud.pvtz.Zone("zone", zone_name="foo.example.com")
 * first = alicloud.vpc.Network("first",
 *     vpc_name="the-first-vpc",
 *     cidr_block="172.16.0.0/12")
 * second = alicloud.vpc.Network("second",
 *     vpc_name="the-second-vpc",
 *     cidr_block="172.16.0.0/16")
 * third = alicloud.vpc.Network("third",
 *     vpc_name="the-third-vpc",
 *     cidr_block="172.16.0.0/16")
 * zone_attachment = alicloud.pvtz.ZoneAttachment("zone-attachment",
 *     zone_id=zone.id,
 *     vpcs=[
 *         {
 *             "vpc_id": first.id,
 *         },
 *         {
 *             "vpc_id": second.id,
 *         },
 *         {
 *             "region_id": "eu-central-1",
 *             "vpc_id": third.id,
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var zone = new AliCloud.Pvtz.Zone("zone", new()
 *     {
 *         ZoneName = "foo.example.com",
 *     });
 *     var first = new AliCloud.Vpc.Network("first", new()
 *     {
 *         VpcName = "the-first-vpc",
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var second = new AliCloud.Vpc.Network("second", new()
 *     {
 *         VpcName = "the-second-vpc",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var third = new AliCloud.Vpc.Network("third", new()
 *     {
 *         VpcName = "the-third-vpc",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var zone_attachment = new AliCloud.Pvtz.ZoneAttachment("zone-attachment", new()
 *     {
 *         ZoneId = zone.Id,
 *         Vpcs = new[]
 *         {
 *             new AliCloud.Pvtz.Inputs.ZoneAttachmentVpcArgs
 *             {
 *                 VpcId = first.Id,
 *             },
 *             new AliCloud.Pvtz.Inputs.ZoneAttachmentVpcArgs
 *             {
 *                 VpcId = second.Id,
 *             },
 *             new AliCloud.Pvtz.Inputs.ZoneAttachmentVpcArgs
 *             {
 *                 RegionId = "eu-central-1",
 *                 VpcId = third.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		zone, err := pvtz.NewZone(ctx, "zone", &pvtz.ZoneArgs{
 * 			ZoneName: pulumi.String("foo.example.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		first, err := vpc.NewNetwork(ctx, "first", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-first-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		second, err := vpc.NewNetwork(ctx, "second", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-second-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		third, err := vpc.NewNetwork(ctx, "third", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String("the-third-vpc"),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pvtz.NewZoneAttachment(ctx, "zone-attachment", &pvtz.ZoneAttachmentArgs{
 * 			ZoneId: zone.ID(),
 * 			Vpcs: pvtz.ZoneAttachmentVpcArray{
 * 				&pvtz.ZoneAttachmentVpcArgs{
 * 					VpcId: first.ID(),
 * 				},
 * 				&pvtz.ZoneAttachmentVpcArgs{
 * 					VpcId: second.ID(),
 * 				},
 * 				&pvtz.ZoneAttachmentVpcArgs{
 * 					RegionId: pulumi.String("eu-central-1"),
 * 					VpcId:    third.ID(),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.pvtz.Zone;
 * import com.pulumi.alicloud.pvtz.ZoneArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.pvtz.ZoneAttachment;
 * import com.pulumi.alicloud.pvtz.ZoneAttachmentArgs;
 * import com.pulumi.alicloud.pvtz.inputs.ZoneAttachmentVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var zone = new Zone("zone", ZoneArgs.builder()
 *             .zoneName("foo.example.com")
 *             .build());
 *         var first = new Network("first", NetworkArgs.builder()
 *             .vpcName("the-first-vpc")
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var second = new Network("second", NetworkArgs.builder()
 *             .vpcName("the-second-vpc")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var third = new Network("third", NetworkArgs.builder()
 *             .vpcName("the-third-vpc")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var zone_attachment = new ZoneAttachment("zone-attachment", ZoneAttachmentArgs.builder()
 *             .zoneId(zone.id())
 *             .vpcs(
 *                 ZoneAttachmentVpcArgs.builder()
 *                     .vpcId(first.id())
 *                     .build(),
 *                 ZoneAttachmentVpcArgs.builder()
 *                     .vpcId(second.id())
 *                     .build(),
 *                 ZoneAttachmentVpcArgs.builder()
 *                     .regionId("eu-central-1")
 *                     .vpcId(third.id())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   zone:
 *     type: alicloud:pvtz:Zone
 *     properties:
 *       zoneName: foo.example.com
 *   first:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-first-vpc
 *       cidrBlock: 172.16.0.0/12
 *   second:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-second-vpc
 *       cidrBlock: 172.16.0.0/16
 *   third:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: the-third-vpc
 *       cidrBlock: 172.16.0.0/16
 *   zone-attachment:
 *     type: alicloud:pvtz:ZoneAttachment
 *     properties:
 *       zoneId: ${zone.id}
 *       vpcs:
 *         - vpcId: ${first.id}
 *         - vpcId: ${second.id}
 *         - regionId: eu-central-1
 *           vpcId: ${third.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Private Zone attachment can be imported using the id(same with `zone_id`), e.g.
 * ```sh
 * $ pulumi import alicloud:pvtz/zoneAttachment:ZoneAttachment example abc123456
 * ```
 * @property lang The language of code.
 * @property userClientIp The user custom IP address.
 * @property vpcIds The id List of the VPC with the same region, for example:["vpc-1","vpc-2"].
 * @property vpcs See `vpcs` below.Recommend to use `vpcs`.
 * @property zoneId The name of the Private Zone Record.
 */
public data class ZoneAttachmentArgs(
    public val lang: Output<String>? = null,
    public val userClientIp: Output<String>? = null,
    public val vpcIds: Output<List<String>>? = null,
    public val vpcs: Output<List<ZoneAttachmentVpcArgs>>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.ZoneAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.ZoneAttachmentArgs =
        com.pulumi.alicloud.pvtz.ZoneAttachmentArgs.builder()
            .lang(lang?.applyValue({ args0 -> args0 }))
            .userClientIp(userClientIp?.applyValue({ args0 -> args0 }))
            .vpcIds(vpcIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcs(vpcs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ZoneAttachmentArgs].
 */
@PulumiTagMarker
public class ZoneAttachmentArgsBuilder internal constructor() {
    private var lang: Output<String>? = null

    private var userClientIp: Output<String>? = null

    private var vpcIds: Output<List<String>>? = null

    private var vpcs: Output<List<ZoneAttachmentVpcArgs>>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The language of code.
     */
    @JvmName("kunsppreatriayat")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The user custom IP address.
     */
    @JvmName("kkaqorpacdykodci")
    public suspend fun userClientIp(`value`: Output<String>) {
        this.userClientIp = value
    }

    /**
     * @param value The id List of the VPC with the same region, for example:["vpc-1","vpc-2"].
     */
    @JvmName("bunxabwavdvrfsjm")
    public suspend fun vpcIds(`value`: Output<List<String>>) {
        this.vpcIds = value
    }

    @JvmName("hxjdxhfmuyxtaeps")
    public suspend fun vpcIds(vararg values: Output<String>) {
        this.vpcIds = Output.all(values.asList())
    }

    /**
     * @param values The id List of the VPC with the same region, for example:["vpc-1","vpc-2"].
     */
    @JvmName("btvylwkbjjqiosvq")
    public suspend fun vpcIds(values: List<Output<String>>) {
        this.vpcIds = Output.all(values)
    }

    /**
     * @param value See `vpcs` below.Recommend to use `vpcs`.
     */
    @JvmName("icbdcxtjbwycxwon")
    public suspend fun vpcs(`value`: Output<List<ZoneAttachmentVpcArgs>>) {
        this.vpcs = value
    }

    @JvmName("eggwcnlomtysxxqg")
    public suspend fun vpcs(vararg values: Output<ZoneAttachmentVpcArgs>) {
        this.vpcs = Output.all(values.asList())
    }

    /**
     * @param values See `vpcs` below.Recommend to use `vpcs`.
     */
    @JvmName("dccytytimjyswvth")
    public suspend fun vpcs(values: List<Output<ZoneAttachmentVpcArgs>>) {
        this.vpcs = Output.all(values)
    }

    /**
     * @param value The name of the Private Zone Record.
     */
    @JvmName("owsikhcrvcrmgxhc")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The language of code.
     */
    @JvmName("aqvfntcvfcbvajre")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The user custom IP address.
     */
    @JvmName("gkbxafosdkwashxr")
    public suspend fun userClientIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userClientIp = mapped
    }

    /**
     * @param value The id List of the VPC with the same region, for example:["vpc-1","vpc-2"].
     */
    @JvmName("qsobkvqaibfxutpy")
    public suspend fun vpcIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcIds = mapped
    }

    /**
     * @param values The id List of the VPC with the same region, for example:["vpc-1","vpc-2"].
     */
    @JvmName("buqcvirmwlixhnlv")
    public suspend fun vpcIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcIds = mapped
    }

    /**
     * @param value See `vpcs` below.Recommend to use `vpcs`.
     */
    @JvmName("tiukwlpdyjufcxlf")
    public suspend fun vpcs(`value`: List<ZoneAttachmentVpcArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcs = mapped
    }

    /**
     * @param argument See `vpcs` below.Recommend to use `vpcs`.
     */
    @JvmName("wynfttrxwataxvum")
    public suspend fun vpcs(argument: List<suspend ZoneAttachmentVpcArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ZoneAttachmentVpcArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpcs = mapped
    }

    /**
     * @param argument See `vpcs` below.Recommend to use `vpcs`.
     */
    @JvmName("hishwanmndvldxty")
    public suspend fun vpcs(vararg argument: suspend ZoneAttachmentVpcArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ZoneAttachmentVpcArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpcs = mapped
    }

    /**
     * @param argument See `vpcs` below.Recommend to use `vpcs`.
     */
    @JvmName("phocwkeoiuvipoaw")
    public suspend fun vpcs(argument: suspend ZoneAttachmentVpcArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ZoneAttachmentVpcArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vpcs = mapped
    }

    /**
     * @param values See `vpcs` below.Recommend to use `vpcs`.
     */
    @JvmName("ugqonbqcpqbttavp")
    public suspend fun vpcs(vararg values: ZoneAttachmentVpcArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcs = mapped
    }

    /**
     * @param value The name of the Private Zone Record.
     */
    @JvmName("ehdjurlqyuawvpjr")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ZoneAttachmentArgs = ZoneAttachmentArgs(
        lang = lang,
        userClientIp = userClientIp,
        vpcIds = vpcIds,
        vpcs = vpcs,
        zoneId = zoneId,
    )
}
