@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ZoneRecord].
 */
@PulumiTagMarker
public class ZoneRecordResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ZoneRecordArgs = ZoneRecordArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ZoneRecordArgsBuilder.() -> Unit) {
        val builder = ZoneRecordArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ZoneRecord {
        val builtJavaResource = com.pulumi.alicloud.pvtz.ZoneRecord(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ZoneRecord(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const zone = new alicloud.pvtz.Zone("zone", {name: "foo.test.com"});
 * const foo = new alicloud.pvtz.ZoneRecord("foo", {
 *     zoneId: zone.id,
 *     rr: "www",
 *     type: "CNAME",
 *     value: "bbb.test.com",
 *     ttl: 60,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * zone = alicloud.pvtz.Zone("zone", name="foo.test.com")
 * foo = alicloud.pvtz.ZoneRecord("foo",
 *     zone_id=zone.id,
 *     rr="www",
 *     type="CNAME",
 *     value="bbb.test.com",
 *     ttl=60)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var zone = new AliCloud.Pvtz.Zone("zone", new()
 *     {
 *         Name = "foo.test.com",
 *     });
 *     var foo = new AliCloud.Pvtz.ZoneRecord("foo", new()
 *     {
 *         ZoneId = zone.Id,
 *         Rr = "www",
 *         Type = "CNAME",
 *         Value = "bbb.test.com",
 *         Ttl = 60,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		zone, err := pvtz.NewZone(ctx, "zone", &pvtz.ZoneArgs{
 * 			Name: pulumi.String("foo.test.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pvtz.NewZoneRecord(ctx, "foo", &pvtz.ZoneRecordArgs{
 * 			ZoneId: zone.ID(),
 * 			Rr:     pulumi.String("www"),
 * 			Type:   pulumi.String("CNAME"),
 * 			Value:  pulumi.String("bbb.test.com"),
 * 			Ttl:    pulumi.Int(60),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.pvtz.Zone;
 * import com.pulumi.alicloud.pvtz.ZoneArgs;
 * import com.pulumi.alicloud.pvtz.ZoneRecord;
 * import com.pulumi.alicloud.pvtz.ZoneRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var zone = new Zone("zone", ZoneArgs.builder()
 *             .name("foo.test.com")
 *             .build());
 *         var foo = new ZoneRecord("foo", ZoneRecordArgs.builder()
 *             .zoneId(zone.id())
 *             .rr("www")
 *             .type("CNAME")
 *             .value("bbb.test.com")
 *             .ttl(60)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   zone:
 *     type: alicloud:pvtz:Zone
 *     properties:
 *       name: foo.test.com
 *   foo:
 *     type: alicloud:pvtz:ZoneRecord
 *     properties:
 *       zoneId: ${zone.id}
 *       rr: www
 *       type: CNAME
 *       value: bbb.test.com
 *       ttl: 60
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Private Zone Record can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:pvtz/zoneRecord:ZoneRecord example abc123456
 * ```
 */
public class ZoneRecord internal constructor(
    override val javaResource: com.pulumi.alicloud.pvtz.ZoneRecord,
) : KotlinCustomResource(javaResource, ZoneRecordMapper) {
    /**
     * User language.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The priority of the Private Zone Record. At present, only can "MX" record support it. Valid values: [1-99]. Default to 1.
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Private Zone Record ID.
     */
    public val recordId: Output<String>
        get() = javaResource.recordId().applyValue({ args0 -> args0 })

    /**
     * The remark of the Private Zone Record.
     */
    public val remark: Output<String>?
        get() = javaResource.remark().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource record of the Private Zone Record.
     */
    @Deprecated(
        message = """
  Field 'resource_record' has been deprecated from version 1.109.0. Use 'rr' instead.
  """,
    )
    public val resourceRecord: Output<String>
        get() = javaResource.resourceRecord().applyValue({ args0 -> args0 })

    /**
     * The rr of the Private Zone Record.
     */
    public val rr: Output<String>
        get() = javaResource.rr().applyValue({ args0 -> args0 })

    /**
     * Resolve record status. Value:
     * - ENABLE: enable resolution.
     * - DISABLE: pause parsing.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ttl of the Private Zone Record. Default to `60`.
     */
    public val ttl: Output<Int>?
        get() = javaResource.ttl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the Private Zone Record. Valid values: A, CNAME, TXT, MX, PTR, SRV.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    public val userClientIp: Output<String>?
        get() = javaResource.userClientIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The value of the Private Zone Record.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })

    /**
     * The name of the Private Zone Record.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object ZoneRecordMapper : ResourceMapper<ZoneRecord> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.pvtz.ZoneRecord::class == javaResource::class

    override fun map(javaResource: Resource): ZoneRecord = ZoneRecord(
        javaResource as
            com.pulumi.alicloud.pvtz.ZoneRecord,
    )
}

/**
 * @see [ZoneRecord].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ZoneRecord].
 */
public suspend fun zoneRecord(name: String, block: suspend ZoneRecordResourceBuilder.() -> Unit): ZoneRecord {
    val builder = ZoneRecordResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ZoneRecord].
 * @param name The _unique_ name of the resulting resource.
 */
public fun zoneRecord(name: String): ZoneRecord {
    val builder = ZoneRecordResourceBuilder()
    builder.name(name)
    return builder.build()
}
