@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.pvtz.kotlin

import com.pulumi.alicloud.pvtz.ZoneRecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const zone = new alicloud.pvtz.Zone("zone", {name: "foo.test.com"});
 * const foo = new alicloud.pvtz.ZoneRecord("foo", {
 *     zoneId: zone.id,
 *     rr: "www",
 *     type: "CNAME",
 *     value: "bbb.test.com",
 *     ttl: 60,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * zone = alicloud.pvtz.Zone("zone", name="foo.test.com")
 * foo = alicloud.pvtz.ZoneRecord("foo",
 *     zone_id=zone.id,
 *     rr="www",
 *     type="CNAME",
 *     value="bbb.test.com",
 *     ttl=60)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var zone = new AliCloud.Pvtz.Zone("zone", new()
 *     {
 *         Name = "foo.test.com",
 *     });
 *     var foo = new AliCloud.Pvtz.ZoneRecord("foo", new()
 *     {
 *         ZoneId = zone.Id,
 *         Rr = "www",
 *         Type = "CNAME",
 *         Value = "bbb.test.com",
 *         Ttl = 60,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/pvtz"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		zone, err := pvtz.NewZone(ctx, "zone", &pvtz.ZoneArgs{
 * 			Name: pulumi.String("foo.test.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = pvtz.NewZoneRecord(ctx, "foo", &pvtz.ZoneRecordArgs{
 * 			ZoneId: zone.ID(),
 * 			Rr:     pulumi.String("www"),
 * 			Type:   pulumi.String("CNAME"),
 * 			Value:  pulumi.String("bbb.test.com"),
 * 			Ttl:    pulumi.Int(60),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.pvtz.Zone;
 * import com.pulumi.alicloud.pvtz.ZoneArgs;
 * import com.pulumi.alicloud.pvtz.ZoneRecord;
 * import com.pulumi.alicloud.pvtz.ZoneRecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var zone = new Zone("zone", ZoneArgs.builder()
 *             .name("foo.test.com")
 *             .build());
 *         var foo = new ZoneRecord("foo", ZoneRecordArgs.builder()
 *             .zoneId(zone.id())
 *             .rr("www")
 *             .type("CNAME")
 *             .value("bbb.test.com")
 *             .ttl(60)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   zone:
 *     type: alicloud:pvtz:Zone
 *     properties:
 *       name: foo.test.com
 *   foo:
 *     type: alicloud:pvtz:ZoneRecord
 *     properties:
 *       zoneId: ${zone.id}
 *       rr: www
 *       type: CNAME
 *       value: bbb.test.com
 *       ttl: 60
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Private Zone Record can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:pvtz/zoneRecord:ZoneRecord example abc123456
 * ```
 * @property lang User language.
 * @property priority The priority of the Private Zone Record. At present, only can "MX" record support it. Valid values: [1-99]. Default to 1.
 * @property remark The remark of the Private Zone Record.
 * @property resourceRecord The resource record of the Private Zone Record.
 * @property rr The rr of the Private Zone Record.
 * @property status Resolve record status. Value:
 * - ENABLE: enable resolution.
 * - DISABLE: pause parsing.
 * @property ttl The ttl of the Private Zone Record. Default to `60`.
 * @property type The type of the Private Zone Record. Valid values: A, CNAME, TXT, MX, PTR, SRV.
 * @property userClientIp
 * @property value The value of the Private Zone Record.
 * @property zoneId The name of the Private Zone Record.
 */
public data class ZoneRecordArgs(
    public val lang: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val remark: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'resource_record' has been deprecated from version 1.109.0. Use 'rr' instead.
  """,
    )
    public val resourceRecord: Output<String>? = null,
    public val rr: Output<String>? = null,
    public val status: Output<String>? = null,
    public val ttl: Output<Int>? = null,
    public val type: Output<String>? = null,
    public val userClientIp: Output<String>? = null,
    public val `value`: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.pvtz.ZoneRecordArgs> {
    override fun toJava(): com.pulumi.alicloud.pvtz.ZoneRecordArgs =
        com.pulumi.alicloud.pvtz.ZoneRecordArgs.builder()
            .lang(lang?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .remark(remark?.applyValue({ args0 -> args0 }))
            .resourceRecord(resourceRecord?.applyValue({ args0 -> args0 }))
            .rr(rr?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .userClientIp(userClientIp?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ZoneRecordArgs].
 */
@PulumiTagMarker
public class ZoneRecordArgsBuilder internal constructor() {
    private var lang: Output<String>? = null

    private var priority: Output<Int>? = null

    private var remark: Output<String>? = null

    private var resourceRecord: Output<String>? = null

    private var rr: Output<String>? = null

    private var status: Output<String>? = null

    private var ttl: Output<Int>? = null

    private var type: Output<String>? = null

    private var userClientIp: Output<String>? = null

    private var `value`: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value User language.
     */
    @JvmName("cuqgmuoiaefyywdg")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The priority of the Private Zone Record. At present, only can "MX" record support it. Valid values: [1-99]. Default to 1.
     */
    @JvmName("jxlpkkoyocrwyies")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The remark of the Private Zone Record.
     */
    @JvmName("lrhwautljjienmya")
    public suspend fun remark(`value`: Output<String>) {
        this.remark = value
    }

    /**
     * @param value The resource record of the Private Zone Record.
     */
    @Deprecated(
        message = """
  Field 'resource_record' has been deprecated from version 1.109.0. Use 'rr' instead.
  """,
    )
    @JvmName("eaqhdbxmulldktkw")
    public suspend fun resourceRecord(`value`: Output<String>) {
        this.resourceRecord = value
    }

    /**
     * @param value The rr of the Private Zone Record.
     */
    @JvmName("eqhxlbclommcxpbf")
    public suspend fun rr(`value`: Output<String>) {
        this.rr = value
    }

    /**
     * @param value Resolve record status. Value:
     * - ENABLE: enable resolution.
     * - DISABLE: pause parsing.
     */
    @JvmName("ttlvnhscmpbcdnnw")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The ttl of the Private Zone Record. Default to `60`.
     */
    @JvmName("bopytvdpmapxjymi")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value The type of the Private Zone Record. Valid values: A, CNAME, TXT, MX, PTR, SRV.
     */
    @JvmName("kwkkggyupqvvfpem")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("idqhdglcvgdvpktf")
    public suspend fun userClientIp(`value`: Output<String>) {
        this.userClientIp = value
    }

    /**
     * @param value The value of the Private Zone Record.
     */
    @JvmName("oulyfcnwmxobucek")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the Private Zone Record.
     */
    @JvmName("ecaxxmloyecsxhve")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value User language.
     */
    @JvmName("urbqjtvfpoblsdbx")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The priority of the Private Zone Record. At present, only can "MX" record support it. Valid values: [1-99]. Default to 1.
     */
    @JvmName("surattdvyxrxiwyc")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The remark of the Private Zone Record.
     */
    @JvmName("jdplhisqwijglqyk")
    public suspend fun remark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remark = mapped
    }

    /**
     * @param value The resource record of the Private Zone Record.
     */
    @Deprecated(
        message = """
  Field 'resource_record' has been deprecated from version 1.109.0. Use 'rr' instead.
  """,
    )
    @JvmName("fsqxjrlmlbkjhjgu")
    public suspend fun resourceRecord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceRecord = mapped
    }

    /**
     * @param value The rr of the Private Zone Record.
     */
    @JvmName("dalffhntqaiobhbg")
    public suspend fun rr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rr = mapped
    }

    /**
     * @param value Resolve record status. Value:
     * - ENABLE: enable resolution.
     * - DISABLE: pause parsing.
     */
    @JvmName("jdnxobltejqdnlnw")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The ttl of the Private Zone Record. Default to `60`.
     */
    @JvmName("unsmravnbtfrthra")
    public suspend fun ttl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    /**
     * @param value The type of the Private Zone Record. Valid values: A, CNAME, TXT, MX, PTR, SRV.
     */
    @JvmName("pxgxmlgomlburowj")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("usnavibuolwnlwfv")
    public suspend fun userClientIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userClientIp = mapped
    }

    /**
     * @param value The value of the Private Zone Record.
     */
    @JvmName("phpuoetiumbktwdi")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    /**
     * @param value The name of the Private Zone Record.
     */
    @JvmName("eygokjckftvvbfjo")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ZoneRecordArgs = ZoneRecordArgs(
        lang = lang,
        priority = priority,
        remark = remark,
        resourceRecord = resourceRecord,
        rr = rr,
        status = status,
        ttl = ttl,
        type = type,
        userClientIp = userClientIp,
        `value` = `value`,
        zoneId = zoneId,
    )
}
